// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of APE.
// 
// The exception is that, if you link the APE library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the APE library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name APE.  If you copy code from other releases into a copy of
// APE, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for APE, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#ifndef	__APE_MACROS_H__
#define	__APE_MACROS_H__

// Commonly used APE macros

#define	ENTER_CRITICAL	EnterMutex();
#define	LEAVE_CRITICAL	LeaveMutex();
#define	ENTER_DEFERRED	setCancel(THREAD_CANCEL_DEFERRED);
#define LEAVE_DEFERRED 	setCancel(THREAD_CANCEL_IMMEDIATE);

// These macros override common functions with thread-safe versions. In
// particular the common "libc" sleep() has problems since it normally
// uses SIGARLM (as actually defined by "posix").  The pthread_delay and
// usleep found in libpthread are gaurenteed not to use SIGALRM and offer
// higher resolution. 

#define	sleep(x)	ape_sleep((x) * 1000)
#define	delay(x)	ape_sleep(x)
#define	yield()		ape_yield()

// Some tests for DLL relared macros.

#ifndef	__EXPORT
#define	__EXPORT
#endif

#ifndef	__DLL
#define	__DLL
#endif

// Hide APE class names so they do not collide with other C++ libraries.
// Macros are used to provide a portable means of hiding rather than
// relying on namespace support.

#define File			ape_File
#define NewFile			ape_NewFile
#define NamedPipe		ape_NamedPipe
#define MappedFile		ape_MappedFile
#define LockedFile		ape_LockedFile
#define SharedFile		ape_SharedFile
#define	Socket			ape_Socket
#define	TCPSocket		ape_TCPSocket
#define	TCPStream		ape_TCPStream
#define	TCPSession		ape_TCPSession
#define	UDPSocket		ape_UDPSocket
#define	UDPBroadcast		ape_UDPBroadcast
#define	UDPTransmit		ape_UDPTransmit
#define	UDPReceive		ape_UDPReceive
#define	UDPDuplex		ape_UDPDuplex
#define	SocketPort		ape_SocketPort
#define	TimerPort		ape_TimerPort
#define	SocketService		ape_SocketService
#define InetAddress		ape_InetAddress 
#define InetMaskAddress		ape_InetMaskAddress
#define InetHostAddress		ape_InetHostAddress
#define BroadcastAddress	ape_BroadcastAddress
#define Mutex			ape_Mutex
#define MutexCounter		ape_MutexCounter
#define Semaphore		ape_Semaphore
#define Event			ape_Event
#define Buffer			ape_Buffer
#define FixedBuffer		ape_FixedBuffer
#define Pipe			ape_Pipe
#define Thread			ape_Thread
#define	ThreadKey		ape_ThreadKey
#define	MemPager		ape_MemPager
#define	Keydata			ape_Keydata
#endif

