// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of APE.
// 
// The exception is that, if you link the APE library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the APE library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name APE.  If you copy code from other releases into a copy of
// APE, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for APE, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "fileio.h"
#include "thread.h"
#include "socket.h"
#include <fcntl.h>
#include <errno.h>

#ifndef	O_NONBLOCK
#define	O_NONBLOCK	O_NDELAY
#endif

UDPTransmit::UDPTransmit(InetAddress &ia, short port, short foreign) : 
UDPSocket(ia, port)
{
	if(!foreign)
		foreign = port;

	Disconnect();	// assure not started live
	peer.sin_port = htons(foreign);
};

sockerror_t UDPTransmit::Connect(InetHostAddress &ia)
{
	int len = sizeof(peer);

	if(isBroadcast())
		setBroadcast(false);

	peer.sin_family = AF_INET;
	peer.sin_addr = getaddress(ia);
	if(connect(so, (sockaddr *)&peer, len))
		return connectError();
	return SOCKET_SUCCESS;
}

sockerror_t UDPTransmit::Connect(BroadcastAddress &subnet)
{
	int len = sizeof(peer);

	if(!isBroadcast())
		setBroadcast(true);

	peer.sin_family = AF_INET;
	peer.sin_addr = getaddress(subnet);
	if(connect(so, (sockaddr *)&peer, len))
		return connectError();
	return SOCKET_SUCCESS;
}

#ifdef	AF_UNSPEC
sockerror_t UDPTransmit::Disconnect(void)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);

	memset(&addr, 0, len);
	addr.sin_family = AF_UNSPEC;
	if(connect(so, (sockaddr *)&addr, len))
		return connectError();
	return SOCKET_SUCCESS;
}
#else
sockerror_t UDPTransmit::Disconnect(void)
{
	return Connect(getLocal());
}
#endif

UDPReceive::UDPReceive(InetAddress &ia, short port, short foreign) : 
UDPSocket(ia, port)
{
	if(!foreign)
		foreign = port;

	peer.sin_port = htons(foreign);
};

sockerror_t UDPReceive::Connect(InetHostAddress &ia)
{
	int len = sizeof(peer);

	peer.sin_family = AF_INET;
	peer.sin_addr = getaddress(ia);
	if(connect(so, (sockaddr *)&peer, len))
		return connectError();
	return SOCKET_SUCCESS;
}

#ifdef	AF_UNSPEC
sockerror_t UDPReceive::Disconnect(void)
{
	struct sockaddr_in addr;
	int len = sizeof(addr);

	memset(&addr, 0, len);
	addr.sin_family = AF_UNSPEC;
	if(connect(so, (sockaddr *)&addr, len))
		return connectError();
	return SOCKET_SUCCESS;
}
#else
int UDPTransmit::Disconnect(void)
{
	return Connect(getLocal());
}
#endif

UDPDuplex::UDPDuplex(InetAddress &bind, short from, short to) :
UDPTransmit(bind, from, to), UDPReceive(bind, from, to)
{};

sockerror_t UDPDuplex::Connect(InetHostAddress &host)
{
	sockerror_t rtn = UDPTransmit::Connect(host);
	if(rtn)
	{
		UDPTransmit::Disconnect();
		UDPReceive::Disconnect();
		return rtn;
	}
	return UDPReceive::Connect(host);
}

sockerror_t UDPDuplex::Disconnect(void)
{
	sockerror_t rtn = UDPTransmit::Disconnect();
	return UDPReceive::Disconnect();
}

sockerror_t UDPDuplex::setRouting(bool enable)
{
	sockerror_t rtn = UDPTransmit::setRouting(enable);
	if(rtn)
		return rtn;
	return UDPReceive::setRouting(enable);
}

