// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of APE.
// 
// The exception is that, if you link the APE library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the APE library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name APE.  If you copy code from other releases into a copy of
// APE, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for APE, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#include "fileio.h"
#include "thread.h"
#include "file.h"

Pipe::Pipe(int size, int count)
{
	objsize = size;
	objcount = count;
	if(!CreatePipe(&reader, &writer, NULL, 0))
		throw(this);
};

Pipe::Pipe(const Pipe &p)
{
	HANDLE pidHandle = GetCurrentProcess();

	if(!DuplicateHandle(pidHandle, p.reader, pidHandle, &reader, 0, FALSE, DUPLICATE_SAME_ACCESS))
		reader = NULL;

	if(!DuplicateHandle(pidHandle, p.writer, pidHandle, &writer, 0, FALSE, DUPLICATE_SAME_ACCESS))
		writer = NULL;

	if(!reader || !writer)
		throw(this);
};

Pipe::~Pipe()
{
	CloseHandle(reader);
	CloseHandle(writer);
};

Pipe &Pipe::operator=(const Pipe &p)
{
	HANDLE pidHandle = GetCurrentProcess();
	CloseHandle(reader);
	CloseHandle(writer);

	if(!DuplicateHandle(pidHandle, p.reader, pidHandle, &reader, 0, FALSE, DUPLICATE_SAME_ACCESS))
		reader = NULL;

 	if(!DuplicateHandle(pidHandle, p.writer, pidHandle, &writer, 0, FALSE, DUPLICATE_SAME_ACCESS))
		writer = NULL;

	if(!reader || !writer)
			throw(this);

	return *this;
}
/*
int Pipe::Send(void *addr)
{
	DWORD count;

	if(!WriteFile(writer, addr, (DWORD)objsize, &count, NULL))
		return -1;

	return (int)count;
}

int Pipe::Recieve(void *addr)
{
	DWORD count;

	if(!ReadFile(reader, addr, (DWORD)objsize, &count, NULL))
		return -1;

	return (int)count;
}

*/
