/**********************************************************************
 * C/C++ Source: serialecho.cc
 *
 * Defines the methods for the SerialEcho class
 *
 * Created: Sat Oct 14 12:38:24 EDT 2000
 * $Log: serialecho.cpp,v $
 * Revision 1.1  2000/10/15 17:54:54  dyfet
 * serial demo
 *
 * Revision 1.3  2000/10/14 21:08:57  garym
 * First working version of the modem echo
 *
 *
 * @author:  Gary Lawrence Murphy <garym@canada.com>
 * Copyright:  2000 TeleDynamics Communications Inc (www.teledyn.com)
 * @version: $Id: serialecho.cpp,v 1.1 2000/10/15 17:54:54 dyfet Exp $
 ********************************************************************
*/
// Copyright (C) 1999-2000 Teledynamics Communications Inc.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "serialecho.h"

SerialEcho::SerialEcho(const char *device, 
                       cc_Semaphore *start = NULL, 
                       int priority = 0, int stacksize = 0) :
  TTYSession( device, start, priority, stacksize ) {

  cout << "Creating SerialEcho" << endl;

  if (!(*this)) {
    throw xError();
    exit(1);
  } else {
    cout << "modem ready" << endl;
  }

  Interactive(false);

  if (setSpeed(38400)) cout << getErrorString() << endl;
  if (setCharBits(8)) cout << getErrorString() << endl;
  if (setParity(SERIAL_PARITY_NONE)) cout << getErrorString() << endl;
  if (setStopBits(1)) cout << getErrorString() << endl;
  if (setFlowControl(SERIAL_FLOW_HARD)) cout << getErrorString() << endl;

  cout << "config done" << endl;
}

void SerialEcho::OnPolling(void) {
  cout << "polling method call" << endl;
  cc_Thread::OnPolling();
}

void SerialEcho::OnSignal(int signo) {
  cout << "polling method call" << endl;
  cc_Thread::OnSignal(signo);
}

void SerialEcho::Run() {
  char b, s[getBufferSize()];

  cout << "start monitor" << endl;

  while (s[0] != 'X') {
    while (isPending(SERIAL_PENDING_INPUT)) {
      cout.put( get() );
    } 
    Sleep(500);
  }

  cout << "end of monitor" << endl;
  Exit();
}

