// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#ifndef __RTS_AUDIO_H__
#define __RTS_AUDIO_H__

#ifndef __APE_THREAD_H__
#include <APE/thread.h>
#endif

enum
{
	RTS_AUDIO_UNSUPPORTED = 0,
	RTS_AUDIO_ULAW,
	RTS_AUDIO_8KHZ = RTS_AUDIO_ULAW,
	RTS_AUDIO_ADPCM,
	RTS_AUDIO_PCM16,
	RTS_AUDIO_CDMONO,
	RTS_AUDIO_CDSTERIO
};

/**
 * The abstract audio codec base class is used to define common inheretance
 * for all audio codec handlers.  This allows reference to an effective
 * codec for the current payload format through a pointer as used in the
 * RTPAudio classes.
 * 
 * @short Base class for all audio codecs. 
 * @author David Sugar (dyfet@ostel.com)
 */
class AudioCodec
{
private:
protected:
public:
	/**
	 * Encode an audio stream in the current format.  This normally
	 * is used to compress u-law 8bit 8khz audio in derived classes as 
	 * all higher sampled audio is generally not codec processed.  The
	 * default codec simply copies the data stream.
	 * 
	 * @return number of bytes after codec or 0 if unsupported sampling.
	 * @param source data to read from.
	 * @param target to write codec converted data.
	 * @param len in bytes of original data stream.
	 */
	virtual size_t Encode(unsigned char *target, unsigned char *source, size_t len) = 0;
	/**
	 * Decode an audio stream in the current payload format.  This
	 * normally is used to decompress into u-law 8 bit 8khz audio in
	 * derived classes as all higher sampled audio is generally not
	 * compressed.
	 * 
	 * @return number of bytes after codec or 0 if unsupported sampling.
	 * @param source of encoded audio data.
	 * @param target for decoded audio data.
	 * @param len of encoded audio data.
	 */
	virtual size_t Decode(unsigned char *target, unsigned char *source, size_t len) = 0;
};

#endif
