/* arrserv_udp_2.h
   
   Author: Marko Meyer
   Date:   95/12/21 (creation)
   Time-stamp: <96/01/27 19:11:30 mme>

   Headerfile for the UDP Array Server [array_serv_udp_3.cc].
   This defines the appropriate classes and data structures.

   	BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995	Marko Meyer

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer, Teichstrasse 27, D-08289 Schneeberg, Germany
	
	History:

	95/12/21 -- Marko Meyer: derived this file from arrserv_udp.h
	                         including handling for pipes.
*/

#ifndef _ARRAY_SERV_UDP_H_
#define _ARRAY_SERV_UDP_H_

#include <arrman-t.new.h>
#include <netbacknet.h>

#include <fcntl.h>

#include <sys/shm.h>

#define MAXREQUESTS 100
#define IS_VALID 1
#define IS_INVALID 0

struct Req_Table
{
	int Magic;
	int sock;
	sockaddr_in address;
	Buffer_Info Req_Buf;
	Buffer_Info Ans_Buf;
	struct timeval ins_time;
	int valid;
};

class C_ArrayServ
{
	char *name;
	char *copyright;

	int Req_T_Pipe[2];   /* The Request-Table-Pipe. */

	int Req_Sock;   /* The socket for incoming requests. */

	int Shm_ID;

	pid_t Par_ID;     /* PID of the parent. */
	pid_t Own_ID;     /* Our PID. */
	pid_t Cld_ID;     /* PID of the child. */

	C_Array<DVLEN> Store; /* Our store. */

	int Note_and_Wakeup(sockaddr_in *Claddr, Buffer_Info *Request);
	int Process_Request(sockaddr_in *Claddr, Buffer_Info *Req_Buf);
	void handle_SIGCLD();
	void handle_SIGINT();

	int Run_Server();
	int Run_T_Fill();

  public:
	C_ArrayServ(char *serv_name, short port);
	int Run();
	~C_ArrayServ();
};

#endif /*_ARRAY_SERV_UDP_H_*/
	
