/* neuron_aa.h
   Headerfile for functions implemented in a single neuron, being presented as
   an object in C++. 

   Author: Ralf Schmidt
   Date: 30.09.1995 (creation)
   Time-stamp: <96/02/07 15:47:12 mme> (last modification)      
   
   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Ralf Schmidt.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: rsc@informatik.th-zwickau.de
   Ordinary Mail: Ralf Schmidt
                  Neuplanitzer Strasse 41
				  D-08062 Zwickau
                  F.R.G.

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  F.R.G.
*/

#ifndef _NEURON_AA_
#define _NEURON_AA_
#include <neuron.h>

class C_Neuron_aa:public C_Neuron
{
  protected:

	S_NNet_Param *S_NNet;
	
	
	virtual int calc_effective_input();      /*calculates effective input*/
    virtual int calc_activity_value();          /*calculates activity*/
    virtual int calc_output_value(int i_Derivation); 
	                              /*calculates output or it's derivation*/
	virtual int modify_weights();         /*modifies weights*/
	virtual int distribute_error();
	                       /*distributes the error to the previous layer*/

	/*some functions for maintenance:*/
	virtual int Init_GWI(ifstream *I_GWI_File);  /*initializes from 
												   GWI-File*/
	
	virtual int Init_GV(ELEMTYPE Min,ELEMTYPE Max);
	    /*initialize with GV[Min,Max]*/
	virtual int Init_(ELEMTYPE Value);
	
	virtual int Create_Wgt_List(int i_Count,ELEMTYPE Cont);
   		/*creates weighlist i_Count elems long, each filled with Cont*/
	
	virtual int Destroy_Wgt_List();  
                             /*destroys weightlist using Neuron 
							   information*/
	
	virtual int Load_GWI(ifstream *I_GWI_File);
                                    /*loads Weights from a file 
									  to the list*/
	virtual int Save_GWI(ofstream *O_GWI_Save);
	                                /*saves Weights from a list 
									  to the save*/



  public:
	C_Neuron_aa(S_NNet_Param *S_NNetData, /*pointer to struct with
											nnet-data*/
				S_Layer_Param *S_LayerData, /*pointer to struct 
										   with layer-data*/
				
				C_List<ELEMTYPE> *C_NetLists,  /*pointer to ListManager*/
				int i_NeuNetID,             /*position of neuron within net*/
				int i_InputCount,           /*number of inputs*/
				int i_BiasQuest);            /*using BIAS or not*/
	
	int Init(int i_InitMode,             /*number of initmode*/
			 ifstream *I_GWI_File);        /*file with weights stored*/
	virtual int Recall();                /*Recall-function of neuron*/
	virtual int Learn();                 /*Learn-function of neuron*/
	virtual int Save(ofstream *O_GWI_Save);  /*file with saved 
											   old weights*/
   /* virtual int Read_Help_Input_List(int number,ELEMTYPE *cont);*/ 
	/*This one reads the item number of the Help_Input_List of the neuron*/
	
	/*virtual int Write_Help_Input_List(int number,ELEMTYPE cont);*/
	/*This one writes the item number of the Help_Input_List of the neuron*/
	virtual int Check_Weights(ELEMTYPE i_Stop);
	                                /* checks weights for potential overflows*/

	virtual int Change_Weights(ELEMTYPE divider);
	                                /* changes weights to prevent overflows */
	
	virtual ~C_Neuron_aa();
};	

#endif /* _NEURON_AA_ */




