/* handling.cc -- some functions for easy handling of errors 

   Author: Marko Meyer
   Date: 01.08.1995 (creation)
   01.08.1995 (last modification)


   Copyright (C) 1995	Marko Meyer

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any suggestions, ideas or comments regarding this library
   feel free to contact me:

   Email:	mme@pub.th-zwickau.de
   Ordinary Mail:	Marko Meyer
   Teichstrasse 27
   D-08289 Schneeberg
   Germany
   */

#include <net_errs.h>
#include <backnet.h>

char* Return_ErrorMsg(int i_Error)
{
	switch(i_Error)
	{
	  case ERR_MEMORY_NEU: 
		return "Neuron: Virtual Memory exhausted!";
	  case ERR_INITMD_NEU: 
		return "Neuron: Unknown init mode called!";
	  case ERR_UXPEOF_NEU:
		return "Neuron: Unexpected EOF in weight file!";
	  case ERR_READWG_NEU:
		return "Neuron: Error reading weight file. Weight file not valid.";
	  case ERR_GWINOP_NEU:
		return "Neuron: GWI-File not open.";
	  case ERR_SAVEWG_NEU:
		return "Neuron: Error writing weight file.";
	  case ERR_WGTOVF_NEU:
		return "Neuron: Weight value exceeds size of double.";
	  case ERR_NOIDAT_NEU:
		return "Neuron: (Net-Implement.) No Init Data.";
	  case ERR_WRNVAL_NEU:
		return "Neuron: (Net-Implement.) No correct value given.";
	  case ERR_NEUDES_NEU:
		return "Neuron: (Net-Implement.) No InfoStruct available.";
		
	  case ERR_WRACTN_LAY:
		return "Layer: Wrong action number in Layer-function Action.";
	  case ERR_CRLIST_LAY:
		return "Layer: Error at creating lists in Layer.";
	  case ERR_NOLMAN_LAY:
		return "Layer: No List Manager found.";
	  case ERR_NSINIT_LAY:
		return "Layer: Neuro-Store init failed.";
	  case ERR_NONSTR_LAY:
		return "Layer: No Neuro-Store active.";
	  case ERR_NONEUR_LAY:
		return "Layer: Neuron could not be initialized (internal errors).";
	  case ERR_NONSLS_LAY:
		return "Layer: (Autoass) No NSLS available.";
		
	  case ERR_NOLMAN_NET:
		return "NNet: No ListManager available.";
	  case ERR_NOILST_NET:
		return "NNet: No InputList available.";
	  case ERR_NOLROU_NET:
		return "NNet: No LernOutList available.";
	  case ERR_NOLERR_NET:
		return "NNet: No LastErrList available.";
	  case ERR_NOLSTR_NET:
		return "NNet: No Layer-Store available.";
	  case ERR_MEMORY_NET:
		return "NNet: Virtual memory exhausted!";
	  case ERR_GWINOP_NET:
		return "NNet: Weight not accessible. Check existence/permissions.";
	  case ERR_READWG_NET:
		return "NNet: Error reading weight file. Weight file not valid.";
	  case ERR_ETYNAR_NET:
		return "NNet: Neuron-Cnt Array is empty.";
	  case ERR_GWICOL_NET:
		return "NNet: Weight file and Net don't fit. Neuron amounts are 
                different.";
	  case ERR_LDREAD_NET:
		return "NNet: Error at reading Layer data.";
	  case ERR_NONAME_NET:
		return "NNet: No Name found in function Action.";
	  case ERR_NOIMST_NET:
		return "NNet: Pattern file not accessible. Check 
                existence/permissions.";
	  case ERR_READMS_NET:
		return "NNet: Pattern file invalid. Maybe not enough patterns within.";
	  case ERR_MSTCOL_NET:
		return "NNet: Pattern file and Net don't fit. Different amounts of 
                input Neurons.";
	  case ERR_WRACTN_NET:
		return "NNet: Wrong 'Action' specified.";
	  case ERR_NOILRN_NET:
		return "NNet: Learn pattern file not accessible. Check 
                existence/permissions.";
	  case ERR_NOOERR_NET:
		return "NNet: Error file not accessible. Check existence/permissions.";
	  case ERR_READLR_NET:
		return "NNet: Error reading in learn pattern file.";
	  case ERR_LRNCOL_NET:
		return "NNet: Learn pattern file and Net don't fit. The amount of 
                output Neurons is different.";
	  case ERR_WRTEER_NET:
		return "NNet: Error writing in error file.";
	  case ERR_BCOLIS_NET:
		return "NNet: Learn pattern file and pattern file don't fit. The 
                amount of patterns is different.";
	  case ERR_WRWHER_NET:
		return "NNet: Wrong 'Where' given to Load_Pattern(...).";
	  case ERR_NOOOUT_NET:
		return "NNet: Output file could not be opened. Check permissions!";
	  case ERR_WRTOUT_NET:
		return "NNet: Error writing to output file.";
	  case ERR_CRTSAV_NET:
		return "NNet: Error saving weights.";
	  case ERR_TAKLAY_NET:
		return "NNet: Error at taking Layer (Take_Layer(int)).";
	  case ERR_NOASSL_NET:
		return "NNet: (Autoass) No Autoassociator Layer found.";
		
	  case ERR_MEMORY_NWK:
		return "Networking: Virtual memory exhausted.";
	  case ERR_UKSVNM_NWK:
		return "Networking: Unknown server name.";
	  case ERR_USSNPO_NWK:
		return "Networking: Unset port AND server name.";
	  case ERR_NDSSUP_NWK:
		return "Networking: Can't open stream socket.";
	  case ERR_NBLCAD_NWK:
		return "Networking: Can't bind local address.";
	  case ERR_UKEMTP_NWK:
		return "Networking: Unknown emergency type.";
	  case ERR_SNDEMR_NWK:
		return "Networking: Error at sending emergency AS.";
	  case ERR_TIMOUT_NWK:
		return "Networking: A send/receive timed out.";
	  case ERR_REQNIS_NWK:
		return "Networking: Unsatisfied NISt-Request.";
	  case ERR_NOCONN_NWK:
		return "Networking: Can't connect.";
	  case ERR_REQRDS_NWK:
		return "Networking: Unsatisfied RDSt-Request.";
	  case ERR_RCNTZR_NWK:
		return "Networking: RDSt_Cnt as sent in RS is zero.";
	  case ERR_NOAUDP_NWK:
		return "Networking: No address given at UDP send.";
	  case ERR_SOCKNS_NWK:
		return "Networking: Socket type not supported.";
	  case ERR_UNKREQ_NWK:
		return "Networking: Unknown RequestID.";

	  case RET_CRTSEM_ARS:
		return "ArrayServer: Error at create_sem.";
	  case RET_SHMGET_ARS:
		return "ArrayServer: Error at shmget.";
	  case RET_SHMATT_ARS:
		return "ArrayServer: Error at shmat.";
	  case RET_NOSOCK_ARS:
		return "ArrayServer: Error at set_up_udp.";
	  case RET_NOFORK_ARS:
		return "ArrayServer: Error at fork.";
	  case RET_DWNSEM_ARS:
		return "ArrayServer: Error at down_sem.";
	  case RET_SHMDTH_ARS:
		return "ArrayServer: Error at shmdt.";
	  case RET_SHMCTL_ARS:
		return "ArrayServer: Error at shmctl.";
	  case RET_WUPSEM_ARS:
		return "ArrayServer: Error at wakeup_sem.";
	  case RET_SIGCLD_ARS:
		return "ArrayServer: Process received SIGCLD.";
	  case RET_SIGINT_ARS:
		return "ArrayServer: Process received SIGINT.";
	  case RET_MKPIPE_ARS:
		return "ArrayServer: Error at pipe.";
	  case RET_RDPIPE_ARS:
		return "ArrayServer: Error at read from pipe.";
	  case RET_WRPIPE_ARS:
		return "ArrayServer: Error at write to pipe.";
		
	  default:
		return "Unknown, maybe internal or multiple error.";
	}
}
