/*
 * cccc_ast.h
 * definition of the abstract syntax tree interface for the cccc project
 *
 * $Log: cccc_ast.h,v $
 * Revision 1.3  1997/05/02 13:14:08  cccc210
 * added Java support
 *
 * Revision 1.2  1997/04/03 11:01:19  a6
 * version 2.06
 *
 * Revision 1.1  1996/10/27 16:14:08  a4
 * Initial revision
 *
 * Revision 2.0  1996/09/17 12:04:20  a2
 * initial version for version 2 work
 *
 * Revision 2.0  1996/09/17 11:13:26  a2
 * *** empty log message ***
 *
 * Revision 1.7  1996/07/18 14:02:29  a1
 * compileable version after introduction of ParseState and CCCC_String
 *
 * Revision 1.6  1996/06/24 13:50:25  a1
 * backing up - this version dumps core in diagnostics
 *
 * Revision 1.5  1996/06/08 01:10:09  a1
 * checking in before embarking on major re-engineering
 *
 * Revision 1.4  1996/05/27 16:02:14  a1
 * work on revised version
 *
 * Revision 1.3  1996/05/26 13:47:57  a1
 * work on version 2
 *
 * Revision 1.2  1995/11/05 11:22:14  a4
 * added emphasis method punc to usage message
 *
 * Revision 1.1  1995/11/04  13:49:32  a4
 * Initial revision
 *
 */

#ifndef __CCCC_AST_H
#define __CCCC_AST_H

#include "cccc.h"
#include "ASTBase.h"
#include "ATokPtr.h"
#include "cccc_tok.h"
#include "AParser.h"
#include "cccc_utl.h"

class AST : public ASTBase {
  friend ostream& operator << (ostream&, AST&);
public:
  ANTLRToken token;

  // elements to control output
  int bPrintNode, bCanonicalElement;

  // canonical name of the element
  CCCC_String& canonical_name();  /* function to recursively generate the name */
  static char *szCurrentRuleName;
  char *szRuleName;
  // first and last token
  ANTLRToken *first_token();
  ANTLRToken *last_token();
      
  // start and end line of the source code covered by the AST
  int nStartLine();
  int nEndLine();
  
  // access function for counts accumulated from tokens included in the AST
  getCount(TokenCount tc);
  
  char *filename, *classname, *membername;

  AST();
  
  AST(ANTLRTokenPtr t);
  AST(AST& ast);
  virtual ~AST();
  virtual AST& operator =(AST&);
  void free_subtrees();
    
  void preorder(ostream &os=cerr);
  void preorder_action();
  void preorder_before_action();
  void preorder_after_action();
  
  /* supress the normal error reporting */
  void syn(
    _ANTLRTokenPtr,
    ANTLRChar*,
    SetWordType*,
    ANTLRTokenType,
    int
  ) {}
};

ostream& operator << (ostream&, AST&);


#endif



















