
/*
 * cccc_tbl.h
 * 
 * defines the database used by CCCC to generate a report
 */
#ifndef CCCC_TBL_H
#define CCCC_TBL_H

#include <iostream.h>
#include <iomanip.h>

#include "cccc_stg.h"
#include "cccc_met.h"


// CCCC_Table is an array of pointers to CCCC_Record's
template <class T, int size> class CCCC_Table {
   T **ptr_array;
   int number_of_records, max_records;
 public:
   CCCC_Table();
   ~CCCC_Table();
   int records() {	return number_of_records; }
   T* find(T* existing_item_ptr);
   T* find_or_insert(T* new_item_ptr);
   T* append(T* new_item_ptr);
   T* record_ptr(int index) { return ptr_array[index]; }
   virtual int get_count(const char *count_tag);
   void sort();
};

#endif // CCCC_DB_H

