
#include "cccc_tbl.h"
#include "cccc_db.h"

#define LINE_BUFFER_SIZE 1000


template <class T, int size> CCCC_Table<T,size>::CCCC_Table() 
{
      max_records=size;
      ptr_array=new T*[size];
      number_of_records=0; 
}

template <class T, int size> CCCC_Table<T,size>::~CCCC_Table() 
{ 
  int i;
  for(i=0; i<number_of_records; i++) 
    { 
      delete ptr_array[i];
      ptr_array[i]=0;
    }
  delete[] ptr_array;
  ptr_array=0;
}

template<class T, int size> 
int CCCC_Table<T,size>::get_count(const char* count_tag) {
  int retval=0;
  int i;
  for(i=0; i<number_of_records; i++) 
{
    retval=retval+ptr_array[i]->get_count(count_tag);
  }
  return retval;
}

template<class T, int size> 
T* CCCC_Table<T,size>::find(T* existing_item_ptr)
{
  T *retval;
  int i=0;
  CCCC_String entity_key=existing_item_ptr->key();
  while( 
	(i < number_of_records) && 
	strcmp(entity_key,ptr_array[i]->key()) 
	) 
    { 
      i++; 
    }
  
  if(i < number_of_records) 
  {
    // we are pointing at the right element
    retval=ptr_array[i];
  }
  else
  {
    // we dropped off the end of the list, so the find failed
    retval=NULL;
  }

  return retval;
}

template<class T, int size> 
T* CCCC_Table<T,size>::find_or_insert(T* new_item_ptr)
{
  T *retval=find(new_item_ptr);
  if(retval==NULL)
  {
     retval=append(new_item_ptr);
  }
  return retval;
}


template<class T, int size> 
T* CCCC_Table<T,size>::append(T* new_item_ptr)
{
  T* retval=NULL;
  if(number_of_records<max_records) 
  {
    ptr_array[number_of_records]=new_item_ptr;
    retval=new_item_ptr; 
    number_of_records++;
  }
  return retval;
} 

template <class T, int size> void CCCC_Table<T,size>::sort() {
  qsort(ptr_array,number_of_records,sizeof(T*),rank_by_string);
  int i;
  for(i=0; i<number_of_records; i++)
    {
      record_ptr(i)->sort();
    }
}



// explicit template instantiations
// this is done differently by different compilers
#ifdef OSF_TEMPLATES
#pragma define_template CCCC_Table<CCCC_Extent,10>
#pragma define_template CCCC_Table<CCCC_Extent,10000>
#pragma define_template CCCC_Table<CCCC_Module,10000> 
#pragma define_template CCCC_Table<CCCC_Member,1000> 
#pragma define_template CCCC_Table<CCCC_Member,10000>
#pragma define_template CCCC_Table<CCCC_UseRelationship,10000> 
#else
template class CCCC_Table<CCCC_Extent,10>;
template class CCCC_Table<CCCC_Extent,10000>;
template class CCCC_Table<CCCC_Module,10000>;
template class CCCC_Table<CCCC_Member,1000>;
template class CCCC_Table<CCCC_Member,10000>;
template class CCCC_Table<CCCC_UseRelationship,10000>;
#endif








