#!/usr/global/bin/perl
#
# $Id: CNarray3.pl,v 1.1 1996-08-06 21:40:47+02 steppler Exp $
#
# Perl script to generate CNCL class from template files
#
$TEMPL_DIR  = "<INCDIR>/CNCL";
$TEMPL_NAME = "T_array3";

$local = 0;
$pointer = 0;

require "getopts.pl";

&Getopts("lt:p");

if($opt_t) {
    $TEMPL_DIR = $opt_t;
}

if($opt_l) {
    $local = 1;
}

if($opt_p) {
    $pointer = 1;
}

if($#ARGV < 0) {
    print STDERR "usage: CNarray3 [-p] [-l] [-t template-dir] type\n";
    exit 1;
}



$type  = $ARGV[0];

$xx    = $type;
$xx    =~ s/^CN//;

$name  = substr($xx, 0, 1);
$name  =~ tr/[a-z]/[A-Z]/;
$name  = $name.substr($xx, 1, length($xx)-1);

$file  = "Array3$name";
$a2file= "Array2$name";

$class = "CNArray3$name";
$a2type= "CNArray2$name";

$desc  = "CN_ARRAY3$name";
$desc  =~ tr/[a-z]/[A-Z]/;

$pnt   = "CN$name"."Ptr";
$pnt   =~ s/Object/Obj/;

$stype = $pointer ? $pnt : $type;


open(INH, "$TEMPL_DIR/$TEMPL_NAME.hP" )
    || die "CNarray3: can't access $TEMPL_NAME.hP\n";
open(INC, "$TEMPL_DIR/$TEMPL_NAME.cP" )
    || die "CNarray3: can't access $TEMPL_NAME.cP\n";

open(OUTH, ">$file.h")
    || die "CNarray3: can't open $file.h\n";
open(OUTC, ">$file.c")
    || die "CNarray3: can't open $file.c\n";


while(<INH>) {
    if( /^<<TYPEDEF/ ) {
	if($pointer) {
	    print OUTH "typedef $type *$pnt;\n";
	}
	next;
    }

    s/%%/\$/g;
    s/<CLASS>/$class/g;
    s/<DESC>/$desc/g;
    s/<TYPE>/$stype/g;
    s/<A2TYPE>/$a2type/g;
    s/<FILE>/$file/g;
    s/<A2FILE>/$a2file/g;

    print OUTH $_;
}

while(<INC>) {
    if( /^<<TYPEDEF/ ) {
	if($pointer) {
	    print OUTC "typedef $type *$pnt;\n";
	}
	next;
    }

    s/%%/\$/g;
    s/<CLASS>/$class/g;
    s/<DESC>/$desc/g;
    s/<TYPE>/$stype/g;
    s/<A2TYPE>/$a2type/g;
    s/<FILE>/$file/g;
    s/<A2FILE>/$a2file/g;

    print OUTC $_;
}

close(INH);
close(INC);
close(OUTH);
close(OUTC);
