#!/usr/global/bin/perl
#
# $Id: CNhier.pl,v 0.29 1995/07/05 12:47:04 cncl-adm Exp $
#
# Simple parser for CNCL class hierarchy. Only works with one line
#     "class XYZ : public ..."
# declarations.
#

if($#ARGV < 0) {
    print STDERR "usage: CNhier class.h ...\n";
    exit 1;
}


while(<>) {

    # Simple "class XYZ;" class declaration
    if( /^ *class +([A-Za-z0-9_]+) *;/ ) {
	next;
    }

    if( /^ *class +([A-Za-z0-9_]+) *: *(public)? *([A-Za-z0-9_]+)/ ) {
	if($heir{$3}) {
	    $heir{$3} = $heir{$3}." ".$1;
	}
	else {
	    $heir{$3} = $1;
	}
	$top{$1} = 0;
    }
    elsif( /^ *class +([A-Za-z0-9_]+)/ ) {
	$top{$1} = 1;
    }
}


sub print_hier {
    local($c,$lvl) =@_;
    local($cc);

    print "  " x $lvl;
    print "$c\n";
    $lvl++;

    for $cc (sort split(' ', $heir{$c})) {
	&print_hier($cc, $lvl);
    }
}
    
for $c (sort keys %top) {
    if($top{$c}) {
	&print_hier($c, 0);
    }
}
