/*
 * Fuzzy Rules Compiler
 *
 * $Id: fuzzysubs.c,v 0.29 1995/07/05 12:47:06 cncl-adm Exp $
 *
 * fuzzysubs.c - list management routines (code)
 */

#include "fuzzysubs.h"
#include <string.h>
#include <malloc.h>

/* Add a node to the tail of the list */
void add(struct List *l, struct Node *n)
{
    if (l->head == NULL)
	l->head = n;
    else 
	l->tail->next = n;

    n->next = NULL;
    l->tail = n;
}

/* Find a named node in the list */
struct Node *findname(struct List *l, char *name)
{
    struct Node *n = l->head;
    
    while (n && strcmp((char *)n->data, name)) n = n->next;
    
    return(n);
}

/* Create a new node */
struct Node *newnode(long size, void *data)
{
    struct Node *n = (struct Node *)calloc(1, size);
    n->data = data;
    return(n);
}

/* Add a named node to the list, but only if it does not yet exist */
struct Node *addnewname(struct List *l, long size, char *name)
{
    struct Node *n = NULL;
    
    if (!findname(l, name))
    {
	n = newnode(size, strdup(name));
	add(l, n);
    }
    
    return(n);
}

/* Free all nodes in the list */
void freelist(struct List *l)
{
    struct Node *n = l->head;
    
    while (n)
    {
	struct Node *next = n->next;
	free(n);
	n = next;
    }
    l->head = NULL;
}

/* Free all named nodes in the list */
void freenamelist(struct List *l)
{
    struct Node *n = l->head;
    
    while (n)
    {
	struct Node *next = n->next;
	free(n->data);
	free(n);
	n = next;
    }
    l->head = NULL;
}
