// -*- C++ -*-

// Example program 'car' for the new GIST-Interface

// This is a simple program to demonstrate how to move objects,
// to make them visible and invisible and to change the look
// of them during a simulation 

#include <CNCL/gist.h>

main (int, char ** ) {

// first of all do a little communication
   Comm comm;

// then create a world for the objects and set the starttime
   double simtime = 5.0;
   GISTWorld world(comm, "Car-World", 0, 100, 0, 80, simtime);

// create a new GISTObject 'Car'
   GISTObject *car = new GISTObject(world, "Car");

// define some attributes

// attribute for moving the car around
   GISTCoordAttribute *position = new GISTCoordAttribute (car, "Position");

// put the car at the position (100,50) at starttime
   position->put(simtime, 100, 50);

// attribute for the visibility of the car
   GISTTextAttribute *visible = new GISTTextAttribute (car, "Visible");

// turn visibility on
   visible->put(simtime, "on");

// chose an attribute for the look of the car so that it can be changed
// during the simulation
   GISTTextAttribute *look = new GISTTextAttribute(car, "Look");

// first of all we chose the tiff-picture 'car1' for the image of the car
   look->put(simtime, "car1"); 

// create image of the object 'car'
   GISTImage *car_image = new GISTImage (car, "Car_Image", look, position,
					 10, 5, 0.5, 0.5, 2, visible);

// now the user can start his application
// ...

// some examples: 

// move car from (100, 50) to (50, 50)
   for (int x=100; x>50; x-=2) {
      position->put(simtime++, x, 50);
   };

// turn off the visibility of the car
   visible->put(simtime++, "off");

// now change the look of the car -> load another image ("car3")
   look->put(simtime++, "car3");

// turn on the visibility again
   visible->put(simtime++, "on");

// then move the car from (50, 50) to (0, 50)
   for (int x=50; x>0;x-=2) {
      position->put(simtime++, x, 50);
   };


// etc.

// delete the GISTObject
// Remember: you must not delete all the GISTAttributes, GISTImages or
// GISTPictures of a GISTObject on your own! The GISTObject will care
// about deleting them within its destructor.
   delete car;
}
