//  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Object.c,v 0.31 1996-08-07 17:54:26+02 steppler Exp $
 *
 * CNClass: CNObject --- Base of CNCL inheritance
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "Object.h"
#include "Class.h"



/*
 * Default functions for store_on(), storer(), yielding a warning, when
 * they are called for a non-persistent object.
 */
int CNObject::store_on(CNPstream &)
{
    warning(NIL, "store_on() called for non-persistent ",
	    class_desc()->name()                         );
    return CNERROR;
}

int CNObject::storer(CNPstream &)
{
    warning(NIL, "storer() called for non-persistent ",
	    class_desc()->name()                         );
    return CNERROR;
}

CNPID CNObject::object_id()
{
    warning(NIL, "object_id() called for non-persistent ",
	    class_desc()->name()                         );
    return CNERROR;
}



/*
 * Default functions for print(), dump(), yielding a warning
 */
void CNObject::print(ostream &) const
{
    warning(NIL, "print() not defined for ", class_desc()->name());
}

void CNObject::dump(ostream &) const
{
    warning(NIL, "dump() not defined for ", class_desc()->name());
}



/*
 * Special error function called by XX::cast_from_object() if an
 * invalid type cast is requested.
 *
 * This function actually terminates the program, the return value
 * is not used, but necessary for the cast_from_object() function.
 */
CNObject *CNObject::fatal_type(CNClassDesc from, CNClassDesc to)
{
    fatal(NIL, "invalid type cast: ", from->name(), " -> ", to->name() );
    return NIL;
}



/*
 * Utility functions to print out objects
 */
ostream &operator << (ostream &strm, const CNObject &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNObject *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



// Describing object for class CNObject
static CNClass CNObject_desc("CNObject", "$Revision: 0.31 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_OBJECT = &CNObject_desc;
