//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Param.h,v 0.30 1996-08-07 17:54:30+02 steppler Exp $
 *
 * CNClass: CNParam --- CNParameter object for object creation
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Param_h
#define __Param_h


#include <CNCL/Object.h>
#include <CNCL/Class.h>


/*
 * Type description for class CNParam
 */

extern CNClassDesc CN_PARAM;



/*
 * CNClass CNParam:
 *   Abstract base class for passing parameters to constructor when using
 *   CLASS::new_object() to create objects.
 */

class CNParam : public CNObject
{
  /***** Member functions required by CNCL ***********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PARAM; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PARAM ? TRUE : CNObject::is_a(desc); }
        
    static CNParam *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNParam *)obj;
#   else
	return (CNParam *)( !obj || obj->is_a(CN_PARAM)
	       ? obj : fatal_type(obj->class_desc(), CN_PARAM) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};


#endif /**__Param_h**/
