//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Array.h,v 0.30 1996-08-07 17:54:37+02 steppler Exp $
 *
 * CNClass: CNArray --- Abstract array base class
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Array_h
#define __Array_h

#include <CNCL/Object.h>		// Base class

#include <sys/types.h>

extern CNClassDesc CN_ARRAY;	// CNClass Array description


/*
 * The class Array
 */

class CNArray : public CNObject
{
  public:
    size_t get_size() const			// Get size of array
    { return asize; };
    size_t size() const			// Get size of array
    { return asize; };

    virtual void size(size_t sz=0) = 0;		// Set size of array
    void set_size(size_t sz=0)
    { size(sz); }

  protected:
    size_t asize;
    void range_error(int index) const;

    /***** Constructors ******************************************************/
  public:
    CNArray()             : asize(0)     {}
    CNArray(size_t xsize) : asize(xsize) {}

    /***** Member functions required by CNCL *********************************/
  public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_ARRAY;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_ARRAY ? TRUE : CNObject::is_a(desc);
    };
        
    static CNArray *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNArray *)obj;
#   else
	return (CNArray *)( !obj || obj->is_a(CN_ARRAY)
	       ? obj : fatal_type(obj->class_desc(), CN_ARRAY) );
#   endif
    }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const = 0;
    virtual void dump (ostream &strm = cout) const = 0;
};


#endif /**__Array_h**/
