// -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_                C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_                          N E T W O R K S
 * |_        |_  |_  |_  |_        |_                                C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_                      L I B R A R Y
 *
 * $Id: Array3.c,v 1.1 1996-08-06 21:40:50+02 steppler Exp $
 *
 * Class: CNArray3 --- Base class for 3-dimensional arrays
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#include <CNCL/Class.h>
 
#include <CNCL/Array3.h>

void CNArray3::range_error(int index) const
{
    CNCL::msg() << "index (row) [" << index << "] out of range" << ends;
    
    fatal(NIL, class_desc()->name(), ": ");
}

void CNArray3::range_error(int r, int c, int d) const
{
    CNCL::msg() << "index [" << r << "][" << c << "][" << d << "] out of range" << ends;
    
    fatal(NIL, class_desc()->name(), ": ");
}
 
/***** CNCL stuff for type information ***************************************/
 
// Describing object for class Array3
static CNClass Array3_desc("Array3", "$Revision: 1.1 $", NIL);
 
// "Type" for type checking functions
CNClassDesc CN_ARRAY3 = &Array3_desc;

