// -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * Class: CNArrayDouble  --- 1 dimensional double array class
 *
 * Created from
 * $Id: T_array.cP,v 0.31 1996-08-07 18:11:19+02 steppler Exp $
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "ArrayDouble.h"



/***** Private functions *****************************************************/

void CNArrayDouble::init(size_t sz)
{
    asize = sz;
    array = new double[sz];
    for (size_t i = 0; i < sz; i++)
	array[i] = def_val;
}



void CNArrayDouble::delete_array()
{
    asize = 0;
    if(array)
	delete [] array;
    array = NIL;
}



/***** Constructors **********************************************************/

CNArrayDouble::CNArrayDouble(size_t sz, double def)
{
    def_val = def;
    init(sz);
}



CNArrayDouble::CNArrayDouble(const CNArrayDouble &a)
{
    init(a.asize);
    for (size_t i = 0; i < asize; i++)
	array[i] = a.array[i];
}


CNArrayDouble::~CNArrayDouble()
{
    CNArrayDouble::delete_array();
}



CNArrayDouble &CNArrayDouble::operator = (const CNArrayDouble &a)
{
    delete_array();
    init(a.asize);
    for (size_t i = 0; i < asize; i++)
	array[i] = a.array[i];
    return *this;
}
    


/***** public functions ******************************************************/

void CNArrayDouble::size(size_t sz)  // Set size of array
{
    if (array == NIL)
	init(sz);
    else if (sz != asize)
    {
	double *temp = array;
	array = new double[sz];
	for (size_t i = 0; i < sz; i++)
	    if (i < asize)
		array[i] = temp[i];
	    else
		array[i] = def_val;
	delete[] temp;
	asize = sz;
    }
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNArrayDouble::print(ostream &strm) const
{
    strm << "[ ";
    for(size_t i=0; i<asize; i++)
    {
	strm << array[i];
	if(i != asize-1)
	    strm << ", ";
    }
    strm << " ]";
}

// Debug output
void CNArrayDouble::dump(ostream &strm) const
{
    strm << "CNArrayDouble { $Revision: 0.31 $" << endl;
    strm << "size=" << asize
	 << " array=" << hex << (unsigned long)(array) << dec << endl;
    strm << "values=" << this << endl;
    strm << "}" << endl;
}



/***** CNCL stuff for type ***************************************************/

// Describing object for class CNArrayDouble
static CNClass CNArrayDouble_desc("CNArrayDouble", "$Revision: 0.31 $",
			    CNArrayDouble::new_object);

// "Type" for type checking functions
CNClassDesc CN_ARRAYDOUBLE = &CNArrayDouble_desc;
