//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: AVLTree.h,v 0.30 1996-08-07 17:54:55+02 steppler Exp $
 *
 * Class: CNAVLTree --- AVL balanced binary search tree
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNAVLTree_h
#define __CNAVLTree_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class
#include <CNCL/AVLNode.h>

extern CNClassDesc CN_AVLTREE;	// Class CNAVLTree description


/*
 * The class CNAVLTree
 */

class CNAVLTree : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNAVLTree();				// Default constructor
    CNAVLTree(CNParam *);			// CNParam constructor
    virtual ~CNAVLTree() { delete_all(); };

  public:	/***** Public interface **************************************/
    bool add(CNAVLNode*);
    CNAVLNode *find();
    CNAVLNode *remove();
    bool empty();
    void delete_all();

    CNAVLNode *find_first();
    CNAVLNode *remove_first();
    CNAVLNode *get_root() { return root; };
    unsigned long length() const { return count; };

  private:	/***** Internal private members ******************************/
    CNAVLNode *root;
    unsigned long count;
    bool add_(CNAVLNode *&n);
    void balL_(CNAVLNode *&n);
    void balR_(CNAVLNode *&n);
    void del_(CNAVLNode *&n);
    CNAVLNode *rem_(CNAVLNode *&n);
    CNAVLNode *rem_first_(CNAVLNode *&n);

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_AVLTREE; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_AVLTREE ? TRUE : CNObject::is_a(desc); }
        
    static CNAVLTree *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNAVLTree *)obj;
#   else
	return (CNAVLTree *)( !obj || obj->is_a(CN_AVLTREE)
	       ? obj : fatal_type(obj->class_desc(), CN_AVLTREE) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNAVLTree(param) : new CNAVLTree; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__CNAVLTree_h**/
