//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: QueueLIFO.c,v 0.31 1996-08-07 17:55:35+02 steppler Exp $
 *
 * Class: QueueLIFO --- LIFO queue, n_w = \infty (almost)
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include "QueueLIFO.h"



bool CNQueueLIFO::empty() const
{
    return n == 0;
}


bool CNQueueLIFO::full() const
{
    return FALSE;
}


int CNQueueLIFO::length() const
{
    return n;
}


void CNQueueLIFO::put(CNObject *obj)
{
    list.append(obj);
    n++;
}


CNObject *CNQueueLIFO::get()
{
    CNDLObject *pos;
    CNObject *obj;
    
    pos = list.last();
    if(pos)
    {
        obj = pos->object();
        list.delete_object(pos);
        n--;
    }
    else
        obj = NIL;
    
    return obj;
}

CNObject *CNQueueLIFO::peek()
{
    CNDLObject *pos;
    
    pos = list.last();
    if(pos)
        return pos->object();
    
    return NIL;
}

void CNQueueLIFO::delete_all()
{
    list.delete_all();
    n = 0;
}




/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNQueueLIFO::print(ostream &strm) const
{
    strm << "length=" << n << endl;
    list.print(strm);
}

// Debug output
void CNQueueLIFO::dump(ostream &strm) const
{
    strm << "CNQueueLIFO { $Revision: 0.31 $" << endl
	 << "length=" << n << endl;
    list.dump(strm);
    strm << "}" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNQueueLIFO
static CNClass CNQueueLIFO_desc("CNQueueLIFO", "$Revision: 0.31 $",
			    CNQueueLIFO::new_object);

// "Type" for type checking functions
CNClassDesc CN_QUEUELIFO = &CNQueueLIFO_desc;
