//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SLIterator.h,v 1.4 1996-08-07 17:55:43+02 steppler Exp $
 *
 * Class: CNSLIterator --- Single linked list iterator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNSLIterator_h
#define __CNSLIterator_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_SLITERATOR;	// Class CNSLIterator description

#include "SLList.h"


/*
 * The class CNSLIterator
 */

class CNSLIterator : public CNObject
{
  public:	/***** Constructors ******************************************/
    CNSLIterator();
    CNSLIterator(const CNSLList *new_list);
    CNSLIterator(const CNSLList &new_list);
    CNSLIterator(CNParam *);

  public:	/***** Public interface **************************************/
     // Reset iterator
    void reset(const CNSLList *new_list);
    void reset(const CNSLList &new_list);
    void reset();
    
    // Get object from actual list position
    CNObject *get_object();
    CNObject *object();
    
    // Get position 
    virtual CNSLObject *position();
    virtual CNSLObject *get_position();

    // Set position
    virtual void position(CNSLObject *pos);
    virtual void set_position(CNSLObject *pos);

    // Move pointer to first object, retrieve current object
    CNObject *first_object();
    CNObject *first();
        	    
    // Move pointer to last object, retrieve current object
    CNObject *last_object();
    CNObject *last();
        	    
    // Advance pointer to next object, retrieve current object
    CNObject *next_object();
    CNObject *next();
    CNObject *operator++();		// Prefix ++arg
    CNObject *operator++(int);		// Postfix arg++ (C++ 3.0)

  protected:	/***** Internal private members ******************************/
    const CNSLList *list;               // CNSLList iterated on
    CNSLObject *pnt;			// Actual position in CNSLList



  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SLITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SLITERATOR ? TRUE : CNObject::is_a(desc); }
        
    static CNSLIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSLIterator *)obj;
#   else
	return (CNSLIterator *)( !obj || obj->is_a(CN_SLITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_SLITERATOR) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSLIterator(param) : new CNSLIterator; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNSLIterator &obj);
ostream &operator << (ostream &strm, const CNSLIterator *obj);

#endif /**__CNSLIterator_h**/
