//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: SLObject.h,v 1.4 1996-08-07 17:55:49+02 steppler Exp $
 *
 * Class: CNSLObject --- Single linked object for CNSLList
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNSLObject_h
#define __CNSLObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_SLOBJECT;	// Class CNSLObject description

class CNSLList;

/*
 * The class CNSLObject
 */

class CNSLObject : public CNObject
{
    friend class CNSLList;
    friend class CNDLList;
    
  public:	/***** Constructors ******************************************/
    CNSLObject();
    CNSLObject(CNParam *);
    CNSLObject(CNObject *obj);

  private:
    CNSLObject(const CNSLObject &);
    
  protected:
    // Only CNSLList and heirs of CNSLObject may delete CNSLObject's
    virtual ~CNSLObject() {}
    


  public:	/***** Public interface **************************************/

    // Set/get next pointer
    virtual CNSLObject *next(CNSLObject *p);
    virtual CNSLObject *next();
    virtual CNSLObject *set_next(CNSLObject *p);
    virtual CNSLObject *get_next();

    // Set/get object pointer
    CNObject *object(CNObject *o);
    CNObject *object();
    CNObject *set_object(CNObject *o);
    CNObject *get_object();
    
    // Delete object
    void delete_object();
          

  protected:    /***** Internal private members ******************************/
    CNSLObject *pnext;
    CNObject   *pobj;



  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_SLOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_SLOBJECT ? TRUE : CNObject::is_a(desc); }
        
    static CNSLObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNSLObject *)obj;
#   else
	return (CNSLObject *)( !obj || obj->is_a(CN_SLOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_SLOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNSLObject(param) : new CNSLObject; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNSLObject &obj);
ostream &operator << (ostream &strm, const CNSLObject *obj);

#endif /**__CNSLObject_h**/
