//  -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Test.h,v 1.2 1996-08-07 17:56:11+02 steppler Exp $
 *
 * CNClass: Test --- Created from CNCL template
 *
 * $Log: Test.h,v $
 * Revision 1.2  1996-08-07 17:56:11+02  steppler
 * Cosmetical changes only.
 * Updated headers.
 *
 * Revision 1.1  1995-08-09 19:16:41+02  steppler
 * Initial revision
 *
 * Revision 0.3  1993/01/05  10:17:15  mj
 * Small changes: print() and dump() print template revision.
 *
 * Revision 0.2  1992/12/23  12:48:20  mj
 * Rewrote object creation with static member function for each class.
 * No more exemplar objects.
 *
 * Revision 0.1  1992/12/21  13:51:08  mj
 * First test revision.
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __Test_h
#define __Test_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Object.h>		// Base class

extern CNClassDesc CN_TEST;	// CNClass Test description


/*
 * The class Test
 */

class Test : public CNObject
{
public:
    int get_n() { return n; }

    // Private members
private:
    int n;

    /***** Constructors ******************************************************/
public:
    Test() : n(0) {}				// Default constructor
    Test(int new_n) : n(new_n) {}
    Test(CNParam *) {}			// CNParam constructor
    ~Test()
    {
	cout << "Deleting Test n=" << n << endl;
    }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_TEST;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_TEST ? TRUE : CNObject::is_a(desc);
    };
        
    static Test *cast_from_object(CNObject *obj);// Safe type case
    
    // CNObject creation
    static CNObject *new_object(CNParam *param = NIL);
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__Test_h**/
