// -*- C++ -*-

#include <iostream.h>

#include <CNCL/SLList.h>
#include <CNCL/SLIterator.h>

#include "Test.h"



int main()
{
    CNSLList list;
    
    list.prepend(new Test(111));
    list.prepend(new Test(222));
    list.prepend(new Test(333));
    list.prepend(new Test(444));
    list.prepend(new Test(555));
    list.prepend(new Test(666));
    list.prepend(new Test(777));
    list.prepend(new Test(888));
    list.prepend(new Test(999));

//    cout << list;

    CNSLIterator trav(list);
    CNObject *p;

    // Output original list
    cout << "----------" << endl;
    while( (p = trav++) )
	cout << *p;

    // Add items before and after each second element
    for(trav.reset(list); (p=trav.object());)
    {
	CNSLObject *pos;
	pos = trav.position();
	trav++;
	trav++;
	list.insert_after(pos, new Test(0));
	list.insert_after (pos, new Test(1));
    }
    
    cout << "----------" << endl;
    for(trav.reset(list); (p=trav.object()); trav++)
    {
	cout << *p;
    }

    // Delete all items with n == 0
    for(trav.reset(list); (p=trav.object()); )
    {
	Test *t;
	CNSLObject *pos;

	pos = trav.position();
	trav++;

	t = Test::cast_from_object(p);
	if(t->get_n() == 0)
	{
	    list.delete_object(pos);
	    delete p;
	}
    }

    cout << "----------" << endl;
    for(trav.reset(list); (p=trav.object()); trav++)
    {
	cout << *p;
    }

    cout << "----------Delete all items with n == 1" << endl;
    // Delete all items with n == 1
    for(trav.reset(list); (p=trav.object()); )
    {
	Test *t;
	CNSLObject *pos;

	pos = trav.position();
	trav++;

	t = Test::cast_from_object(p);
	if(t->get_n() == 1)
	{
	    list.delete_object(pos);
	    delete p;
	}
    }

    // Reverse output
    cout << "----------" << endl;
    for(trav.first(); (p=trav.object()); trav++)
    {
	cout << *p;
    }

    // Delete all items
    cout << "----------Delete all items" << endl;
    list.delete_all();
    for(trav.reset(list); (p=trav.object()); trav++)
    {
	cout << *p;
    }
    
//    list.ok();
//    list.dump();
}







