//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EventHIterator.h,v 0.30 1996-08-07 17:56:29+02 steppler Exp $
 *
 * Class: CNEventHIterator --- ...
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __CNEventHIterator_h
#define __CNEventHIterator_h


#include <CNCL/EventIterator.h>		// Base class
#include <CNCL/EventHeapSched.h>


extern CNClassDesc CN_EVENTHITERATOR;	// Class CNEventHIterator description


/*
 * The class CNEventHIterator
 */

class CNEventHIterator : public CNEventIterator
{
    friend class CNEventHeapSched;
    
  private:	/***** Constructors ******************************************/
    CNEventHIterator() {}; 				// Default constructor
    CNEventHIterator(CNParam *) {}			// CNParam constructor
    CNEventHIterator(CNEventHeapSched *);
    
  public:	/***** Public interface **************************************/
    CNEvent *next_event();        // returns an event
    void delete_current_event();  // deletes last returned event
    
  private:	/***** Internal private members ******************************/
    int index;                    // current position in heap
    CNEventHeapSched *sched;      // scheduler who created me
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EVENTHITERATOR; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EVENTHITERATOR ? TRUE : CNEventIterator::is_a(desc); }
        
    static CNEventHIterator *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNEventHIterator *)obj;
#   else
	return (CNEventHIterator *)( !obj || obj->is_a(CN_EVENTHITERATOR)
	       ? obj : fatal_type(obj->class_desc(), CN_EVENTHITERATOR) );
#   endif
    }
    
  private:
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNEventHIterator(param) : new CNEventHIterator; }
  
  public:  
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};



ostream &operator << (ostream &strm, const CNEventHIterator &obj);
ostream &operator << (ostream &strm, const CNEventHIterator *obj);

#endif /**__CNEventHIterator_h**/
