// -*- C++ -*-
/* MM1 Simulation unter CNCL      06.05.93  24.08.93 */

#include <iostream.h>

#include <CNCL/QueueFIFO.h>
#include <CNCL/FiboG.h>
#include <CNCL/NegExp.h>
#include <CNCL/Batches.h>
#include <CNCL/Moments.h>

/* Uncomment for old scheduler */
/* #define NO_HEAP_SCHEDULER */
#include <CNCL/sim.h>

#include <CNCL/Job.h>

enum { NJOBS=100000 };

enum { JOB, TIMER_G, TIMER_S };	// CNEvent types for M/M/1 Simulation

class Server : public CNEventHandler
{
  private:
    CNRandom &rnd_b;		// Distribution of service time 
    CNJob *job;			// Served Job
    CNQueueFIFO  queue;		// CNQueue
    CNMoments t_w, t_b;		// Evaluation tau_w, tau_b
    long n;			// number of jobs
    CNBatches * f_t_w;
    ofstream &ausgabe;

    enum { WAITING, SERVING };
public:
    virtual void event_handler(const CNEvent *ev);
    
    void print_results();
    void eval_job(CNJob *job);
	
    Server(CNRandom &rnd, CNBatches *ausw, ofstream &ausg)
	: rnd_b(rnd), job(NIL), queue(), t_w("tau_w"), t_b("tau_b"),
	  n(1), f_t_w(ausw), ausgabe(ausg)
    {
	cout << "Server lebt !" << endl;
	state(WAITING);
    }
};

class Generator : public CNEventHandler
{
  private:
    CNRandom &rnd_a;			// Distribution of arrival time a
    Server *server;			// Connected queue/server
    long n;
    CNBatches *f_t_w;
    ofstream &ausgabe;
	
  public:
    virtual void event_handler(const CNEvent * ev);
	
    Generator(CNRandom &rnd, Server *serv, CNBatches *ausw, ofstream &ausg)
	: rnd_a(rnd), server(serv), n(1), f_t_w(ausw), ausgabe(ausg)
    {
	cout << "Generator lebt !" << endl;
    }
};

void Generator::event_handler(const CNEvent *ev)
{
    if ( f_t_w->status() == CNStatistics::END) {
	//f_t_w->print(ausgabe);
	f_t_w->print(CNBatches::CDF, ausgabe ) ;
	ausgabe.close();
	return;
    }
//		if (n == NJOBS)
//			return;		// Stop simulation
    if(ev->type() != TIMER_G)
	error("mm1: ", "illegal event in generator");
    
    // Incoming event -> generate new job
    send_now(new CNEvent(JOB, server, new CNJob));
    // CNRandom delay
    send_delay(new CNEvent(TIMER_G), rnd_a());
    n++;
}

void Server::event_handler(const CNEvent *ev)
{
    switch(state())
    {
    case SERVING:
	switch(ev->type())
	{
	case JOB:
	    // Incoming job, put into queue
	    {
		CNJob *job;
		job = (CNJob *)ev->object();
		job->in = now();
		queue.put(job);
	    }
	    break;
	    
	case TIMER_S:
	    // Timer event, service time run down
	    job->out = now();
	    // Evaluate job
	    eval_job(job);
	    delete job;
	    job = NIL;
	    // Get new job from queue
	    if(!queue.empty())
	    {
		job = (CNJob *)queue.get();
		job->start = now();
		send_delay(new CNEvent(TIMER_S), rnd_b());
		state(SERVING);
	    }
	    else
		state(WAITING);
	    break;
	}
	break;
	
    case WAITING:
	switch(ev->type())
	{
	case JOB:
	    // Incoming job
	    job = (CNJob *)ev->object();
	    job->in      = now();
	    job->start   = now();
	    // CNRandom service time
	    send_delay(new CNEvent(TIMER_S), rnd_b());
	    state(SERVING);
	    break;
	}
	break;
    }
}

void Server::eval_job(CNJob *job)
{
    t_w.put(job->start - job->in);
    t_b.put(job->out   - job->in);
    f_t_w->put( (job->start - job->in) );
//		cout << (int) (job->start - job->in) << "   ";
    if ((n % 50000) == 0) {
	f_t_w->print(ausgabe);
	//ausgabe << f_t_w;
	cout << n << endl;
	return;
	n++;
    }
}

void Server::print_results()
{
    cout << t_w << t_b;
}

main()
{
    CNRNG    *rng      = new CNFiboG;
    CNNegExp rnd_a(10, rng);
    CNNegExp rnd_b( 5, rng);
    
    // CNParameter fuer den LRE
    // double fmin, fmax, error;
    // CNParameter des Warteraumes
    //	char*  name = argv[1];		// Name der LRE-Datei
    
    CNBatches *ausw = new CNBatches(0.0, 10.0, 0.02, 10, 10000, 40);

    ofstream          ausgabe( "tmm1-btm.btm", ios::out );
    if(!ausgabe)
	CNCL::fatal("tmm1-lre: ", "can't open file ", "tmm1-btm.btm");
    
    Server            server(rnd_b, ausw, ausgabe);
    Generator         generator(rnd_a, &server, ausw, ausgabe);
    CNEventScheduler  scheduler;
    
    scheduler.start(new CNEvent(TIMER_G, &generator, 0.0));
    
    server.print_results();
}
