//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZD.c,v 0.30 1996-08-07 17:57:04+02 steppler Exp $
 *
 * Class: EZD --- Base class for ezd graphic objects
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "EZD.h"



/*
 * Initialize flag
 */
bool EZD::initialized = FALSE;

/*
 * Pipe to ezd process
 */
CNPipe *EZD::ezd = NIL;

/*
 * Select class for test_event()
 */
CNSelect EZD::sel;


/*
 * Pixel scaling variables
 */
float EZD::scale_x = 1.0, EZD::scale_y = 1.0;


/*
 * Origin 
 */
int EZD::origin_x = 0, EZD::origin_y = 0;


/*
 * Drawing primitives
 */
void EZD::draw_point(int x, int y, CNStringR col)
{
    out() << "(point " << x << " " << y << " " << col << ")" << endl;
    out().flush();
}


void EZD::draw_line(int x1, int y1, int x2, int y2,
	       CNStringR col, int width)
{
    out() << "(line " << x1 << " " << y1 << " " << x2 << " " << y2;
    if(width >= 0)
	out() << " " << width;
    out() << " " << col << ")" << endl;
    out().flush();
}


void EZD::draw_dash_line(int x1, int y1, int x2, int y2,
	       CNStringR col, int width)
{
    out() << "(line " << x1 << " " << y1 << " " << x2 << " " << y2;
    if(width >= 0)
	out() << " " << width;
    out() << " " << col << " dash)" << endl;
    out().flush();
}


void EZD::draw_arc(int x, int y, int w, int h, int a1, int a2,
		   CNStringR col, int width)
{
    out() << "(arc " << x << " " << y << " " << w << " " << h << " "
	  << a1 << " " << a2;
    if(width >= 0)
	out() << " " << width;
    out() << " " << col << ")" << endl;
    out().flush();
}


void EZD::draw_fill_arc(int x, int y, int w, int h, int a1, int a2,
			CNStringR col)
{
    out() << "(fill-arc " << x << " " << y << " " << w << " " << h << " "
	  << a1 << " " << a2;
    out() << " " << col << ")" << endl;
    out().flush();
}

void EZD::draw_pie_arc(int x, int y, int w, int h, int a1, int a2,
          CNStringR col)
{
    out() << "(pie-arc " << x << " " << y << " " << w << " " << h << " "
	  << a1 << " " << a2;
    out() << " " << col << ")" << endl;
    out().flush();
}


void EZD::draw_rectangle(int x, int y, int w, int h,
		    CNStringR col, int width)
{
    out() << "(rectangle " << x << " " << y << " " << w << " " << h;
    if(width >= 0)
	out() << " " << width;
    out() << " " << col << ")" << endl;
    out().flush();
}


void EZD::draw_fill_rectangle(int x, int y, int w, int h, CNStringR col)
{
    out() << "(fill-rectangle " << x << " " << y << " " << w << " " << h
	  << " " << col << ")" << endl;
    out().flush();
}


void EZD::draw_fill_rectangle(int x, int y, int w, int h, CNStringR col,
			      CNStringR stipple)
{
    out() << "(fill-rectangle " << x << " " << y << " " << w << " " << h
	  << " " << col << " " << stipple << ")" << endl;
    out().flush();
}



void EZD::draw_text(int x, int y, CNStringR text,
		    CNStringR col, CNStringR font)
{
    out() << "(text " << x << " " << y << " "
	  << "\"" << text << "\" " << col << " ";
    if(font != "")
	out() << "\"" << font << "\"";
    out() << ")" << endl;
    out().flush();
}


void EZD::draw_text(int x, int y, int w, int h, CNStringR align,
		    CNStringR text, CNStringR col,
		    CNStringR font)
{
    out() << "(text " << x << " " << y << " "
	  << w << " " << h << " " << align << " "
	  << "\"" << text << "\" " << col << " ";
    if(font != "")
	out() << "\"" << font << "\"";
    out() << ")" << endl;
    out().flush();
}


void EZD::draw_bitmap(int x, int y, int w, int h, CNStringR filename,
		      CNStringR color1, CNStringR color2)
{
    if (color2 == "")
	out() << "(bitmap " << x << " " << y << " " << w << " " << h <<
	    " \"" << filename << "\" " << color1 << ")" << endl;
    else
	out() << "(bitmap " << x << " " << y << " " << w << " " << h <<
	    " \"" << filename << "\" " << color1 << " " << 
	    color2 << ")" << endl;
    out().flush();

}

void EZD::draw_bitmap(int x, int y, CNStringR filename,
		      CNStringR color1, CNStringR color2)
{
    if (color2 == "")
	out() << "(bitmap " << x << " " << y << " " << filename << " " 
	      << color1 << ")" << endl;
    else
	out() << "(bitmap " << x << " " << y << " " << filename << " " 
	      << color1 << " " << color2 << ")" << endl;
    out() << "(draw-now)" << endl;
}



/***** See comment in EZD.h **************************************************/
#if CNCL_CC_GCC25

void EZD::draw_text(int x, int y, const char *text,
		    const char *col, const char *font)
{
    out() << "(text " << x << " " << y << " "
	  << "\"" << text << "\" " << col << " ";
    if(*font)
	out() << "\"" << font << "\"";
    out() << ")" << endl;
    out().flush();
}


void EZD::draw_text(int x, int y, int w, int h, const char *align,
		    const char *text, const char *col,
		    const char *font)
{
    out() << "(text " << x << " " << y << " "
	  << w << " " << h << " " << align << " "
	  << "\"" << text << "\" " << col << " ";
    if(*font)
	out() << "\"" << font << "\"";
    out() << ")" << endl;
    out().flush();
}


void EZD::draw_bitmap(int x, int y, int w, int h, const char *filename,
		      const char *color1, const char *color2)
{
    if (*color2)
	out() << "(bitmap " << x << " " << y << " " << w << " " << h <<
	    " \"" << filename << "\" " << color1 << ")" << endl;
    else
	out() << "(bitmap " << x << " " << y << " " << w << " " << h <<
	    " \"" << filename << "\" " << color1 << " " << 
	    color2 << ")" << endl;
    out().flush();

}

void EZD::draw_bitmap(int x, int y, const char *filename,
		      const char *color1, const char *color2)
{
    if (*color2)
	out() << "(bitmap " << x << " " << y << " " << filename << " " 
	      << color1 << ")" << endl;
    else
	out() << "(bitmap " << x << " " << y << " " << filename << " " 
	      << color1 << " " << color2 << ")" << endl;
    out() << "(draw-now)" << endl;
}
#endif /**__GNUC_MINOR__ < 6**/
/*****************************************************************************/


void EZD::draw_now()
{
    out() << "(draw-now)" << endl;
    out().flush();
}

void EZD::draw_clear()
{
    out() << "(clear)" << endl;
    out().flush();
}


/*
 * Flush changes and pause msec milliseconds
 */
void EZD::pause(int msecs)
{
    out() << "(pause " << msecs << ")" << endl;
    out().flush();
}



/*
 * Read event string from pipe from ezd process
 */
CNString EZD::event()
{
    CNString input;
    
    in() >> input;
    return input;
}


bool EZD::test_event()
{
    return sel.select(0, 1000);
}

/*
 * Set values for application to pixel scaling
 */
void EZD::set_scale(const float xscale_x, const float xscale_y,
		    const int xorigin_x, const int xorigin_y)
{
    scale_x = xscale_x;
    scale_y = xscale_y;
    origin_x = xorigin_x;
    origin_y = xorigin_y;
}



/*
 * Save/restore current drawings
 */
void EZD::save_drawing()
{
    out() << "(save-drawing)" << endl;
}

void EZD::restore_drawing()
{
    out() << "(restore-drawing)" << endl;
}



/*
 * Print window to disk (postscript format)
 */
void EZD::print_window(CNStringR winname, CNStringR dateiname)
{
    out() << "(postscript " << winname << " \"" << dateiname << "\")" 
	  << endl;
    out().flush();
}


/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZD::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void EZD::dump(ostream &strm) const
{
    strm << "EZD { $Revision: 0.30 $"
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZD
static CNClass EZD_desc("EZD", "$Revision: 0.30 $",
			  EZD::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZD = &EZD_desc;






