//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDBlock.c,v 0.30 1996-08-07 17:57:07+02 steppler Exp $
 *
 * Class: EZDBlock --- Block with small rectangles for bit display
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "EZDBlock.h"



/*
 * Constructors / destructors
 */



/*
 * Initialize block member and draw
 */
void EZDBlock::initialize(int r, int c, int b)
{
    frame  = FRAME;
    bsize  = b;
    rows   = r;
    cols   = c;
    width  = 2*frame + cols*bsize;
    height = 2*frame + rows*bsize;

    b_colors = new int[rows*cols];
    for(int i=0; i<rows*cols; i++)
	b_colors[i] = FALSE;
}



/*
 * Redraw block
 */
void EZDBlock::redraw()
{
    int i, j;
    
    start();
    rectangle(0, 0, width-1, height-1, "", frame);
    
    for(i=0; i<rows; i++)
	for(j=0; j<cols; j++)
	    fill_rectangle(j*bsize+frame, i*bsize+frame, bsize, bsize,
			   b_colors[j*cols+i] ? color_on : color_off  );
    
    end();
}



/*
 * Turn bit on/off, set color for bit
 */
void EZDBlock::on(int b)
{
    if(b>=0 && b<rows*cols)
    {
	b_colors[b] = TRUE;
	redraw();
    }
}

void EZDBlock::off(int b)
{
    if(b>=0 && b<rows*cols)
    {
	b_colors[b] = FALSE;
	redraw();
    }
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDBlock::print(ostream &strm) const
{
    strm << "..." << endl;
}

// Debug output
void EZDBlock::dump(ostream &strm) const
{
    strm << "EZDBlock { $Revision: 0.30 $ ..."
	 << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDBlock
static CNClass EZDBlock_desc("EZDBlock", "$Revision: 0.30 $",
			    EZDBlock::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDBLOCK = &EZDBlock_desc;
