//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDDiagWin.h,v 0.30 1996-08-07 17:57:14+02 steppler Exp $
 *
 * Class: EZDDiagWin --- Extra window with x-y diagram
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EZDDiagWin_h
#define __EZDDiagWin_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/EZD.h>		// Base class
#include <CNCL/EZDWindow.h>
#include <CNCL/EZDDrawing.h>

extern CNClassDesc CN_EZDDIAGWIN;	// Class EZDDiagWin description


/*
 * The class EZDDiagWin
 */

class EZDDiagWin : public EZD
{
  public:	/***** Constructors ******************************************/
    enum Style { DOT, LINE, HISTO };

    EZDDiagWin()
	: EZD("diagwin"), win(NIL), draw(NIL), vals(NIL), valx(0),
	  valstyle(HISTO), color_draw(""), color_bar("")
        { initialize(name(), -1, -1, WIDTH, HEIGHT, STEP); }
    EZDDiagWin(CNParam *)
	: EZD("diagwin"), win(NIL), draw(NIL), vals(NIL), valx(0),
	  valstyle(HISTO), color_draw(""), color_bar("")
        { initialize(name(), -1, -1, WIDTH, HEIGHT, STEP); }
    EZDDiagWin(int w, int h, Style s=LINE)
	: EZD("diagwin"), win(NIL), draw(NIL), vals(NIL), valx(0),
	  valstyle(s), color_draw(""), color_bar("")
        { initialize(name(), -1, -1, w, h, STEP); }
    EZDDiagWin(CNStringR n, int w, int h, Style s=LINE)
	: EZD(n), win(NIL), draw(NIL), vals(NIL), valx(0),
	  valstyle(s), color_draw(""), color_bar("")
        { initialize(name(), -1, -1, w, h, STEP); }
    EZDDiagWin(CNStringR n, CNStringR title,
	       int w, int h, Style s=LINE)
	: EZD(n), win(NIL), draw(NIL), vals(NIL), valx(0),
	  valstyle(s), color_draw(""), color_bar("")
        { initialize(title, -1, -1, w, h, STEP); }
    EZDDiagWin(CNStringR n, CNStringR title,
	       int w, int h, int st, CNStringR cd, CNStringR cb, Style s=LINE)
	: EZD(n), win(NIL), draw(NIL), vals(NIL), valx(0),
	  valstyle(s), color_draw(cd), color_bar(cb)
        { initialize(title, -1, -1, w, h, st); }

    ~EZDDiagWin();
    
  public:	/***** Public interface **************************************/
    void style(Style s);
    void add(int v);
    void clear();
    void set();					// Set drawing to diag win
    
  private:	/***** Internal private members ******************************/
    enum { WIDTH=200, HEIGHT=100, STEP=1 };
    enum { SCROLL_STEP=40 };
    
    EZDWindow *win;			// Window used
    EZDDrawing *draw;			// Drawing used
    int width, height;			// Width, height of window
    int *vals;				// Array of values
    int valx;				// Current x position
    int valstep;			// x pixel increment
    int valn;				// Max. # of values
    Style valstyle;			// Drawing style
    CNString color_draw;		// Color for drawing values
    CNString color_bar;			// Color for <0 bar

    void initialize(CNStringR title, int x, int y, int w, int h, int s);
    void draw_value(int x);
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_EZDDIAGWIN; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_EZDDIAGWIN ? TRUE : EZD::is_a(desc); }
        
    static EZDDiagWin *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDDiagWin *)obj;
#   else
	return (EZDDiagWin *)( !obj || obj->is_a(CN_EZDDIAGWIN)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDDIAGWIN) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDDiagWin(param) : new EZDDiagWin; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__EZDDiagWin_h**/
