//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDWindow.c,v 0.30 1996-08-07 17:57:40+02 steppler Exp $
 *
 * Class: EZDWindow --- Interface to ezd windows
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "EZDWindow.h"
#include <stdio.h>
#include <stdarg.h>

/*
 * Initialize ezd window
 */
void EZDWindow::initialize()
{
    if (w_x == -1 && w_y == -1)
    {
	out() << "(window " << name() << " "
	      << w_width << " " << w_height << " "
	      << "\"" << w_title << "\""
	      << ")" << endl;
    }
    else
    {
	out() << "(window " << name() << " " << w_x << " " << w_y << " "
	      << w_width << " " << w_height << " "
	      << "\"" << w_title << "\""
	      << ")" << endl;
    }
    out().flush();
}


/*
 * Deinitialize ezd window
 */
void EZDWindow::deinitialize()
{
    out() << "(delete-window " << name() << ")" << endl;
    out().flush();
}


/*
 * Overlay drawing
 */
void EZDWindow::overlay(EZDDrawing *d)
{
    if (d->clipx >= 0 && d->clipy >= 0)
	    out() << "(overlay " << name() << " " << d->name() << " " << 
		d->clipx << " " << d->clipy << " " << d->clipwidth << " " 
		<< d->clipheight << ")" << endl;
    else 
	out() << "(overlay " << name() << " " << d->name() << ")" << endl;
    out().flush();
} 


/*
 * Underlay drawing
 */
void EZDWindow::underlay(EZDDrawing *d)
{
    if (d->clipx >= 0 && d->clipy >= 0)
	    out() << "(underlay " << name() << " " << d->name() << " " << 
		d->clipx << " " << d->clipy << " " << d->clipwidth << " " 
		<< d->clipheight << ")" << endl;
    else 
	out() << "(underlay " << name() << " " << d->name() << ")" << endl;
    out().flush();
} 


void EZDWindow::scale_drawing(EZDDrawing *draw, const int origin_x,
			      const int origin_y, const float d_scale_x, 
			      const float d_scale_y, const int scale_linewidth)
{
    out() << "(origin " << name() << " " << draw->name() << " " <<
	origin_x << " " << origin_y << ")" << endl;
    out() << "(scale " << name() << " " << draw->name() << " " << 
	d_scale_x << " " << d_scale_y << " " << scale_linewidth << ")" << endl;
    out().flush();   
}


void EZDWindow::set_zoom(EZDDrawing *draw, const float factor)
{
    out() <<
	"(scheme (let()" <<
	"(define (ZOOM) (let (" <<
	"(mousex *mouse-window-x*)" <<
	"(mousey *mouse-window-y*)" <<
	"(width (list-ref " <<
	"(xgetgeometry *dpy* (window-xwindow (name->window '" << name() <<
	"))) 4))" <<
	"(height (list-ref " <<
	"(xgetgeometry *dpy* (window-xwindow (name->window '" << name() <<
	"))) 5)))" <<
	"(ezd `(origin " << name() << " " << draw->name() << 
	",(* (- 1 " << factor << ") mousex) " <<
	",(* (- 1 " << factor << ") mousey)))"<<
	"(ezd `(scale " << name() << " " << draw->name() <<
	",(/ width " << (float)w_width/factor << ") " <<
	",(/ height " << (float)w_height/factor << ") 1))))" <<
	"(ezd `(click * 2 ,zoom))))" << endl;
    out().flush();
}


void EZDWindow::set_norm(EZDDrawing *draw)
{
    out() << 
	"(scheme (let() (define (NORMAL) (let (" <<
	"(width (list-ref " <<
	"(xgetgeometry *dpy* (window-xwindow (name->window '" << name() <<
	"))) 4))" <<
	"(height (list-ref " <<
	"(xgetgeometry *dpy* (window-xwindow (name->window '" << name() <<
	"))) 5)))" <<
	"(ezd `(origin " << name() << " " << draw->name() << " 0 0))" <<
	"(ezd `(scale " << name() << " " << draw->name() << " " <<
	",(/ width " << width() << ") " <<
	",(/ height " << height() << ") 1))))"
	"(ezd `(click * 3 ,normal))))" << endl;
    out().flush(); 
}


void EZDWindow::set_auto_resize(const int nargs, EZDDrawing *draw ...)
{
    va_list ap;
    EZDDrawing *drawing;
    
    va_start(ap, draw);
    drawing = draw;
    out() << 
	"(scheme (let () " <<
	"(define (RESIZED) (let ((width (list-ref *user-event-misc* 2)) " <<
	"(height (list-ref *user-event-misc* 3))) ";
    for (int i=0; i<nargs; i++)
    {
	if (drawing->clipx >= 0 && drawing->clipy >= 0)
	{
	    out () << "(ezd `(overlay " << name() << " " << drawing->name() << 
		" ,(FLOOR(+ 0.51 (/ width " << 
		(float)w_width/(float)drawing->clipx << 
		"))) ,(FLOOR(+ 0.51 (/ height " << 
		(float)w_height/(float)drawing->clipy << 
		"))) ,(FLOOR(+ 0.49 (/ width " << 
		(float)w_width/(float)drawing->clipwidth << 
		"))) ,(FLOOR(+ 0.49 (/ height " <<
		(float)w_height/(float)drawing->clipheight<< 
		")))))";
	} 
	out() << "(ezd `(origin " << name() << " " << drawing->name() << 
	    " 0 0))";
	out() << "(ezd `(scale " << name() << " " << drawing->name() << " " <<
	",(/ width " << w_width << ") ,(/ height " << w_height << ") 1))";
	drawing = va_arg(ap, EZDDrawing *);
    }
    out() << ")) ";
    out() <<"(ezd `(when * resize ,resized))))" << endl;
    out().flush();
    va_end(ap);
}


void EZDWindow::delete_drawing(EZDDrawing *d)
{
    out() << "(delete-view " << name() << " " << d->name() << ")" << endl;
    out().flush();
}


void EZDWindow::print_window(const CNString &dateiname)
{
    EZD::print_window(name(), dateiname);
}



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void EZDWindow::print(ostream &strm) const
{
    strm << "width=" << width() << " heigth=" << height() << endl;
}

// Debug output
void EZDWindow::dump(ostream &strm) const
{
    strm << "EZDWindow { $Revision: 0.30 $" << endl;
    strm << " width=" << width() << " heigth=" << height() << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class EZDWindow
static CNClass EZDWindow_desc("EZDWindow", "$Revision: 0.30 $",
			  EZDWindow::new_object);

// "Type" for type checking functions
CNClassDesc CN_EZDWINDOW = &EZDWindow_desc;






