//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: EZDWindow.h,v 0.30 1996-08-07 17:57:41+02 steppler Exp $
 *
 * Class: EZDWindow --- Interface to ezd windows
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __EZDWindow_h
#define __EZDWindow_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/EZD.h>		// Base class
#include <CNCL/EZDDrawing.h>

extern CNClassDesc CN_EZDWINDOW;	// Class EZDWindow description


/*
 * The class EZDWindow
 */

class EZDWindow : public EZD
{
public:
    int width()  const { return w_width;  }
    int height() const { return w_height; }
    int wherex() const { return w_x; }
    int wherey() const { return w_y; }
    void overlay(EZDDrawing *);
    void underlay(EZDDrawing *);
    void scale_drawing(EZDDrawing *, const int, const int, const float, 
		      const float, const int);
    void set_zoom(EZDDrawing *, const float);
    void set_norm(EZDDrawing *);
    void set_auto_resize(const int, EZDDrawing * ...);
    void delete_drawing(EZDDrawing *);
    void print_window(const CNString &);
    
    // Private members
private:
    CNString w_title;
    int w_x, w_y;
    int w_width, w_height;
    
    void initialize();
    void deinitialize();
    
    /***** Constructors ******************************************************/
public:
    EZDWindow()
	: EZD("win"), w_title("win"), 
	  w_x(-1), w_y(-1), w_width(200), w_height(200) 
        { initialize(); }
    EZDWindow(CNParam *)
	: EZD("win"), w_title("win"), 
	  w_x(-1), w_y(-1), w_width(200), w_height(200) 
        { initialize(); }
    EZDWindow(int w, int h)
	: EZD("win"), w_title("win"), 
	  w_x(-1), w_y(-1), w_width(w),   w_height(h)
        { initialize(); }
    EZDWindow(int x, int y, int w, int h)
	: EZD("win"), w_title("win"), 
	  w_x(x), w_y(y), w_width(w), w_height(h)   
        { initialize(); }
    EZDWindow(const CNString &name, int w, int h)
	: EZD(name), w_title(name), 
	  w_x(-1), w_y(-1), w_width(w), w_height(h)
        { initialize(); }
    EZDWindow(const CNString &name, int x, int y, int w, int h)
	: EZD(name), w_title(name), 
	  w_x(x), w_y(y), w_width(w), w_height(h)
        { initialize(); }
    EZDWindow(const CNString &name, const CNString &title, int w, int h)
	: EZD(name), w_title(title), 
	  w_x(-1), w_y(-1), w_width(w), w_height(h)
        { initialize(); }
    EZDWindow(const CNString &name, const CNString &title,
	      int x, int y, int w, int h)
	: EZD(name), w_title(title), 
	  w_x(x), w_y(y), w_width(w), w_height(h)
        { initialize(); }
    
    ~EZDWindow() { deinitialize(); }

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_EZDWINDOW;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_EZDWINDOW ? TRUE : EZD::is_a(desc);
    };
        
    static EZDWindow *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (EZDWindow *)obj;
#   else
	return (EZDWindow *)( !obj || obj->is_a(CN_EZDWINDOW)
	       ? obj : fatal_type(obj->class_desc(), CN_EZDWINDOW) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new EZDWindow(param) : new EZDWindow; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__EZDWindow_h**/
