//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FSet.c,v 0.30 1996-08-07 17:58:04+02 steppler Exp $
 *
 * Class: CNFSet --- Fuzzy set abstract base class
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "FSet.h"



/*
 * Constructors
 */
CNFSet::CNFSet(CNParam *)
    : CNNamed(""), ymin(0), ymax(0)
{}


CNFSet::CNFSet(double min, double max)
    : CNNamed(""), ymin(min), ymax(max)
{}


CNFSet::CNFSet(CNStringR xname, double min, double max)
    : CNNamed(xname), ymin(min), ymax(max)
{}



/*
 * Initialize
 */
void CNFSet::init(CNStringR name, double min, double max)
{
    set_name(name);
    ymin = min;
    ymax = max;
}



/*
 * Compute center of gravity for defuzzyfication
 */
double CNFSet::center_of_gravity(double /*min*/, double /*max*/) const
{
    error(NIL, "CNFSet::center_of_gravity(): not yet implemented");
    return 0;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNFSet
static CNClass CNFSet_desc("CNFSet", "$Revision: 0.30 $", NIL);

// "Type" for type checking functions
CNClassDesc CN_FSET = &CNFSet_desc;



