//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: MovingObject.h,v 0.31 1996-08-07 17:58:35+02 steppler Exp $
 *
 * Class: MovingObject --- replacement for GIST1 MovingObject
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __MovingObject_h
#define __MovingObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/gist.h>		// Base class
#include <CNCL/World.h>

extern CNClassDesc CN_MOVINGOBJECT;	// Class MovingObject description


/*
 * The class MovingObject
 */

class MovingObject : public GISTObject
{
  public:	/***** Constructors ******************************************/
    MovingObject(World& w,
		 const char *picname,
		 float x, float y, float width = 0, float height = 0,
		 double time = 0);
    MovingObject(World& w,
		 const char *objectname,
		 const char *picname,
		 float x, float y, float width = 0, float height = 0,
		 double time = 0);

  public:	/***** Public interface **************************************/
    virtual void move(float x, float y, double time);
    virtual void change_look(const char *picname);

  protected:
    MovingObject(World&,const char *);

  private:	/***** Internal private members ******************************/
    double lasttime;
    GISTImage *img;
    GISTCoordAttribute *pos;
    GISTTextAttribute *look;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_MOVINGOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_MOVINGOBJECT ? TRUE : GISTObject::is_a(desc); }
        
    static MovingObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (MovingObject *)obj;
#   else
	return (MovingObject *)( !obj || obj->is_a(CN_MOVINGOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_MOVINGOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam * = NIL) // Object creation
    { return NIL; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__MovingObject_h**/
