//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: ValueObject.h,v 0.31 1996-08-07 17:58:43+02 steppler Exp $
 *
 * Class: ValueObject --- replacement for GIST1 ValueObject
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License. 
 *****************************************************************************/

#ifndef __ValueObject_h
#define __ValueObject_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/ColorfulObject.h>		// Base class

extern CNClassDesc CN_VALUEOBJECT;	// Class ValueObject description


/*
 * The class ValueObject
 */

class ValueObject : public ColorfulObject
{
  public:	/***** Constructors ******************************************/
    enum Displaymode { text, curve };
    ValueObject(World& w,
		const char *objectname,
		const char *color,
		float x, float y, 
		float width = 0.0, float height = 0.0,
		double time = 0.0, 
		Displaymode mode = text);

  public:	/***** Public interface **************************************/
    virtual void move(float x, float y, double time);
    virtual void change_look(const char *picname);
    virtual void change_color(const char *color);
    virtual void change_color(float red, float green, float blue);
    virtual void put_value(double time, float newvalue);

  private:	/***** Internal private members ******************************/
    GISTCurve *crv;
    GISTValueAttribute *val;
    GISTTextAttribute *txt;

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_VALUEOBJECT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_VALUEOBJECT ? TRUE : ColorfulObject::is_a(desc); }
        
    static ValueObject *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (ValueObject *)obj;
#   else
	return (ValueObject *)( !obj || obj->is_a(CN_VALUEOBJECT)
	       ? obj : fatal_type(obj->class_desc(), CN_VALUEOBJECT) );
#   endif
    }
    
    static CNObject *new_object(CNParam * = NIL) // Object creation
    { return NIL; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

#endif /**__ValueObject_h**/
