//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: World.c,v 0.30 1996-08-07 17:58:44+02 steppler Exp $
 *
 * Class: World --- replacement for GIST1 World
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 * 
 * As an exception to this rule you may use this template to generate
 * your own classes. This does not cause these classes to be covered by
 * the GNU Library General Public License. This exception does not
 * however invalidate any other reasons why the resulting program must be
 * covered by the GNU Library General Public License.
 *****************************************************************************/

#include "World.h"

World::World(Comm& comm,
	     float xmin, float xmax, float ymin, float ymax,
	     double starttime)
{
    world_ = new GISTWorld(comm, "GIST-1 world",
			   xmin, xmax, ymin, ymax,
			   starttime);
    bobj = new GISTObject(*world_, "Background-Object");
    bpic = new GISTPicture(bobj, "Background-Picture", -1000);
};

World::~World() {
    delete bobj;
    delete world_;
};

void World::line(float x1, float y1, float x2, float y2) {
    bpic->set_pos(x1,y1);
    bpic->pen_down();
    bpic->set_pos(x2,y2);
    bpic->pen_up();
};

/***** Default I/O member function for CNCL classes **************************/

// Normal output
void World::print(ostream &strm) const
{
    world_->print(strm);
    bobj->print(strm);
    bpic->print(strm);
}

// Debug output
void World::dump(ostream &strm) const
{
    strm << "World { $Revision: 0.30 $" << endl;
    world_->dump(strm);
    bobj->dump(strm);
    bpic->dump(strm);
    strm << " }" << endl;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class World
static CNClass World_desc("World", "$Revision: 0.30 $",
			    World::new_object);

// "Type" for type checking functions
CNClassDesc CN_WORLD = &World_desc;
