// -*- C++ -*-

#include <stdlib.h>

#include <CNCL/String.h>
#include <CNCL/SocketStream.h>



main(int argc, char *argv[])
{
    CNString buffer;
    

    if(argc != 2)
    {
	cerr << "usage: " << argv[0] << " port" << endl;
	exit(1);
    }

    // Socket-Stream erzeugen
    SocketStream s;

    if(atoi(argv[1]))
	s.open(atoi(argv[1]));		// Open with port number
    else
	s.open(argv[1]);		// Open with port name

    if(!s)
    {
	cerr << "Server error: can't create socket stream" << endl;
	exit(1);
    }

    // Auf Verbindungen warten
    while(TRUE)
    {
	s.accept();
	if(!s)
	{
	    cerr << "Server error: accept failed" << endl;
	    exit(1);
	}

	// Meldung
	s << "SocketStream demo server ready." << endl;

	// Alle Eingaben wieder zurueckschicken
    	while(TRUE)
	{	
	    s >> buffer;
	    buffer.strip_crlf();
	    
	    if(!s)
	    {
		cerr << "server: can't read from socket" << endl;
		break;
	    }
	    
	    if( buffer == "."  ||  buffer == "quit" )
		break;

	    cout << buffer << endl;
	    
	    s << "I got: " << buffer << endl;
	}

	s.accept_close();
    }

    /**NOT REACHED**/
    exit(0);
}
