//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Ptr.c,v 1.2 1996-08-07 17:59:25+02 steppler Exp $
 *
 * Class: CNPtr --- Intelligent pointer to CNRefObjs
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include <CNCL/Class.h>

#include "Ptr.h"



/***** Default I/O member function for CNCL classes **************************/

// Normal output
void CNPtr::print(ostream &strm) const
{
    strm << "Ptr to ";
    if(obj)
	strm << obj->class_desc()->name() << " (count=" << obj->get_count()
	     << "): " << *obj;
    else
	strm << "(NIL)" << endl;
}

// Debug output
void CNPtr::dump(ostream &strm) const
{
    strm << "CNPtr { $Revision: 1.2 $" << endl;
    strm << "Ptr to ";
    if(obj)
    {
	strm << obj->class_desc()->name() << " (count=" << obj->get_count()
	     << ")" << endl;
	obj->dump();
    }
    else
	strm << "(NIL)" << endl;
    
    strm << "}" << endl;
}

// IOStream operator <<
ostream &operator << (ostream &strm, const CNPtr &obj)
{
    obj.print(strm);
    return strm;
}

ostream &operator << (ostream &strm, const CNPtr *obj)
{
    if(obj)
	obj->print(strm);
    else
	strm << "(NIL)";
    return strm;
}



/***** CNCL stuff for type information ***************************************/

// Describing object for class CNPtr
static CNClass CNPtr_desc("CNPtr", "$Revision: 1.2 $", CNPtr::new_object);

// "Type" for type checking functions
CNClassDesc CN_PTR = &CNPtr_desc;
