//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: RefNamed.h,v 1.2 1996-08-07 17:59:32+02 steppler Exp $
 *
 * Class: CNRefNamed --- CNNamed with reference counting
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNRefNamed_h
#define __CNRefNamed_h


#include <CNCL/Named.h>		// Base class
#include <CNCL/Ref.h>


extern CNClassDesc CN_REFNAMED;	// Class CNRefNamed description


/*
 * The class CNRefNamed
 */

class CNRefNamed : public CNNamed, public CNRef
{
  public:	/***** Constructors ******************************************/
    CNRefNamed()               : CNNamed()    , CNRef() {}
    CNRefNamed(CNStringR name) : CNNamed(name), CNRef() {}

  protected:
    virtual ~CNRefNamed() {}		// protected: no automatic objects
    CNRefNamed(const CNRefNamed &);	// no copying
    CNRefNamed &operator = (const CNRefNamed &);
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_REFNAMED; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_REFNAMED ? TRUE : CNNamed::is_a(desc); }
        
    static CNRefNamed *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNRefNamed *)obj;
#   else
	return (CNRefNamed *)( !obj || obj->is_a(CN_REFNAMED)
	       ? obj : fatal_type(obj->class_desc(), CN_REFNAMED) );
#   endif
    }
};

#endif /**__CNRefNamed_h**/
