//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: RefObj.h,v 1.2 1996-08-07 17:59:35+02 steppler Exp $
 *
 * Class: CNRefObj --- CNObject with reference counting
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNRefObj_h
#define __CNRefObj_h


#include <CNCL/Object.h>		// Base classes
#include <CNCL/Ref.h>

extern CNClassDesc CN_REFOBJ;	// Class CNRefObj description


/*
 * The class CNRefObj
 */

class CNRefObj : public CNObject, public CNRef
{
  public:	/***** Constructors ******************************************/
    CNRefObj() : CNRef() {}

  protected:
    virtual ~CNRefObj() {}		// protected: no automatic objects
    CNRefObj(const CNRefObj &);		// no copying
    CNRefObj &operator = (const CNRefObj &);
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_REFOBJ; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_REFOBJ ? TRUE : CNObject::is_a(desc); }
        
    static CNRefObj *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNRefObj *)obj;
#   else
	return (CNRefObj *)( !obj || obj->is_a(CN_REFOBJ)
	       ? obj : fatal_type(obj->class_desc(), CN_REFOBJ) );
#   endif
    }
};

#endif /**__CNRefObj_h**/
