//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: String.h,v 0.31 1996-08-07 17:59:38+02 steppler Exp $
 *
 * CNClass: CNString --- Character string
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __String_h
#define __String_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>
#include <CNCL/Object.h>		// Base class

#include <string.h>
#include <sys/types.h>


extern CNClassDesc CN_STRING;	// CNClass CNString description


/*
 * The class CNString
 */

class CNString : public CNObject
{
    enum { default_extra = 10 };                // extra storage allocated  

  public:	/***** Constructors ******************************************/
    CNString()          { init(); }	// Default constructor
    CNString(CNParam *) { init(); }	// CNParam constructor
    CNString(int extra);
    CNString(char);
    CNString(char, int);
    CNString(const char*);
    CNString(const char*, int);
    CNString(const CNString&);
    CNString(const CNString&, int);
    ~CNString();

  public:	/***** Public interface **************************************/
    void resize( unsigned );
    void to_lower();
    void to_upper();
    void capitalize();

    void strip_crlf();
    void strip_lspace();
    void strip_rspace();
    void strip_space();
    
    unsigned capacity() const   { return alloc; }
    unsigned length() const     { return len; }

    CNString  after  (int pos, int l=0) const; 
    CNString  before (int pos, int l=0) const;
    CNString& add    (char c);
    CNString& add    (const char *cs);

    CNString& del    (int pos=0, int l=1);
    CNString& del    (char c,            int pos=0);
    CNString& del    (const CNString& s, int pos=0);
    CNString& del    (const char     *s, int pos=0);

    CNString& insert (char c,            int pos=0);
    CNString& insert (const char     *s, int pos=0);
    CNString& insert (const CNString& s, int pos=0); 

    CNString& replace(char c, int pos=0);
    CNString& replace(char oldc, char newc, int pos=0); 
    CNString& replace(const CNString& s, int pos=0, int l=0);
    CNString& replace(const CNString& olds, const CNString& news, int pos=0);
    
    int downsearch(char c,            int pos=0) const;
    int downsearch(const CNString& s, int pos=0) const;
    int downsearch(const char     *s, int pos=0) const;
    int upsearch  (char c,            int pos=0) const;
    int upsearch  (const CNString& s, int pos=0) const;
    int upsearch  (const char     *s, int pos=0) const;
    
    bool matches  (const char     *s, int pos=0) const;
    bool matches  (const CNString& s, int pos=0) const;

    
    void icopy( istream& strm = cin );

    /***** Operators *********************************************************/
    operator const char * () const { return p; }

    char  operator()(int i) const;
    char& operator[](int i);

    void operator=(const CNString&);
    void operator=(const char*);
    void operator=(char);
    
    friend bool operator <  (const CNString& a, const CNString& b);
    friend bool operator >  (const CNString& a, const CNString& b);
    friend bool operator >= (const CNString& a, const CNString& b);
    friend bool operator <= (const CNString& a, const CNString& b);
    friend bool operator == (const CNString& a, const CNString& b);
    friend bool operator != (const CNString& a, const CNString& b);

    friend CNString operator + (const CNString&, const CNString&);

    CNString& operator += (const CNString&);
    CNString& operator += (const char*);


  private:	/***** Internal private members ******************************/
    size_t alloc;    // storage allocated
    				   
  protected:	/***** Internal protected members ****************************/
    char* p;           // character string
    size_t len;      // length of the string, NULL character not counted
    void init(unsigned l=0, unsigned extra=default_extra);
    void cpyn(const char *s, unsigned n);
    
  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_STRING; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_STRING ? TRUE : CNObject::is_a(desc); }
        
    static CNString *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNString *)obj;
#   else
	return (CNString *)( !obj || obj->is_a(CN_STRING)
	       ? obj : fatal_type(obj->class_desc(), CN_STRING) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNString(param) : new CNString; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};

istream &operator >> (istream& strm, CNString& s);



/*
 * const reference to a CNString typedef
 */
typedef const CNString & CNStringR;
    

#endif /**__String_h**/
