// -*-C++-*-
/*****************************************************************************
 *
 * Test fuer CNCoord/CNICoord
 *
 * $Id: tCoord.c,v 1.3 1996-08-07 17:59:45+02 steppler Exp $
 *
 * $Log: tCoord.c,v $
 * Revision 1.3  1996-08-07 17:59:45+02  steppler
 * Cosmetical changes only.
 * Updated headers.
 *
 * Revision 1.2  1995-08-10 21:50:05+02  steppler
 * Removed GCC 2.7.0 warnings.
 *
 * Revision 1.1  1995/08/09  17:17:28  steppler
 * Initial revision
 *
 *****************************************************************************/

#include <iostream.h>

#include <CNCL/Coord.h>



int main(int, char *[])
{
    CNCoord x, y(3.5, 7.5);
    CNICoord a, b;
    
    CNCoord::set_scale(0.01);
    
    x.x = 4.25;
    x.y = -0.25;
    
    cout << "x = " << x << "\n"
	 << "y = " << y << "\n"
	 << "x + y = " << x + y << "\n"
	 << "x - y = " << x - y << "\n";

    x -= y;
    cout << "x -= y; x = " << x << "\n";

    x += y;
    cout << "x += y; x = " << x << "\n";

    a = CNICoord(x);
    b = CNICoord(y);
    
    cout << "a = " << a << "\n"
	 << "b = " << b << "\n"
	 << "a + b = " << a + b << "\n"
	 << "a - (9,9) = " << a - CNICoord(9,9) << "\n";

    return 0;
}
