// -*- C++ -*-
// $Id: tRef.c,v 1.1 1995/10/02 10:08:02 steppler Exp $

#include <CNCL/RefObj.h>
#include <CNCL/RefNamed.h>
#include <CNCL/Ptr.h>

int main()
{
    bool no_error = TRUE;
    CNRefNamed *ref_named;
    CNRefObj   *ref_obj, *ref_obj2;
    CNPtr      *ptr1, *ptr2;

    CNRef::set_debug(TRUE, TRUE);
    
    ref_named = new CNRefNamed("ref_named");
    ref_named->ref();
    if (ref_named->get_count() == 1)
	cerr << "CNRefNamed -- ok" << endl;
    else
    {
	cerr << "CNRefNamed -- error" << endl;
	no_error = FALSE;
    }
    // delete
    ref_named->deref();

    ref_obj   = new CNRefObj;
    ref_obj->ref();
    if (ref_obj->get_count() == 1)
	cerr << "CNRefObj -- ok" << endl;
    else
    {
	cerr << "CNRefObj -- error" << endl;
	no_error = FALSE;
    }

    ptr1 = new CNPtr(ref_obj);
    ref_obj2   = new CNRefObj;
    ref_obj2->ref();
    ptr2 = new CNPtr(ref_obj2);

    // delete ref_obj2 implicitly
    *ptr2 = *ptr1;

    if (ptr1->get_object() == ptr2->get_object() && ref_obj->get_count() == 2)
	cerr << "CNPtr -- ok" << endl;
    else
    {
	cerr << "CNPtr -- error" << endl;
	no_error = FALSE;
    }

    delete ptr1;
    delete ptr2;

    if (no_error)
	cerr << "CNRef -- ok" << endl;
    else
	cerr << "CNRef -- error" << endl;
    
    return 0;
}
