//    -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PIO.c,v 0.31 1996-08-07 18:00:00+02 steppler Exp $
 *
 * Class: CNPIO --- persistent stream Object IO-formatting
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "PIO.h"


int CNPIO::store_object(CNPstream& strm, CNObject& obj, bool no_ptr_check)
{
    strm << obj.class_desc()->name();	// write classname into file
    if (no_ptr_check)
    {
	strm << '{';	
	obj.storer(strm);		    // write membervariables into file
	strm << '}';
    }
    else
    {
	long ids;
	ids = obj.object_id();
	
	if (CNReaderTbl::is_in(ids))
	{
	    strm << '@';
	    store_id(strm, obj);
	    strm << '@';
	}
	else
	{
	    strm << '*';
	    store_id(strm,obj);
	    obj.storer(strm);
	    CNReaderTbl::add_to_id_tbl(obj.object_id(), obj); 
	    strm << '*';
	}
    }
    return 0;				// return error
}


CNObject* CNPIO::read_object(CNPstream& strm)
{
   char delim;
   
   char class_name[80];
   strm >> class_name;		// read classname from file
   
   char* classname = class_name;
   

   strm >> delim;
   CNObject* target = NIL;
   
   switch(delim)
   {
       case '{':
       {
	   target = CNReaderTbl::reader_ptr_by_classname(classname)(strm);
	   //calls reader-funktion to create a new instanze of "classname"
	   // by getting the reader-function-pointer from the Reader_tbl
	   break;
       }
       case '*':
       {
	   long id_old;
	   strm >> id_old;
	   target = CNReaderTbl::reader_ptr_by_classname(classname)(strm);
	   CNReaderTbl::add_to_id_tbl(id_old, target);
	   break;
       }
       case '@':
       {   
	   long id_old;
	   strm >> id_old;
	   target = CNReaderTbl::get_from_id_tbl(id_old); 
	   break;
       }
       
   }
   
	       
   strm >> delim;
   return target;
}

int CNPIO::store_id(CNPstream& strm, CNObject& obj)
{ 
    strm << obj.object_id();
    return 0;
}

CNPID CNPIO::read_id(CNPstream& strm)
{ 
    long id;
    strm >> id;
    return id;
}
