//    -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PIO.h,v 0.30 1996-08-07 18:00:01+02 steppler Exp $
 *
 * Class: CNPIO --- persistent stream Object IO-formatting
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNPIO_h
#define __CNPIO_h

#include <CNCL/ReaderTbl.h>
#include <CNCL/Pstream.h>
#include <CNCL/PObjectID.h>

class CNPIO : public CNCL
{
public:
   static int store_object(CNPstream& strm, CNObject& obj, bool no_ptr_check = FALSE);
   static CNObject* read_object(CNPstream&);
   static int store_id(CNPstream&, CNObject&);
   static CNPID read_id(CNPstream&);
   
};

#endif




