//    -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: PInt.h,v 0.30 1996-08-07 18:00:04+02 steppler Exp $
 *
 * Class: CNPInt --- class persistent CNInt
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __CNPInt_h
#define __CNPInt_h

#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/Int.h>		// Base class
#include <CNCL/PObjectID.h>

#include <CNCL/PIO.h>        	// Methodes for persistency


extern CNClassDesc CN_PINT;	// Class CNPInt description

/*
 * The class CNPInt
 */

class CNPInt : public CNInt, public CNPObjectID
{
  public:	/***** Constructors ******************************************/ 
    CNPInt(long val=0): CNInt(val), CNPObjectID(){};
    CNPInt(CNPstream&);				
    CNPInt(CNParam *param):CNInt(param),  CNPObjectID(){};	

  public:	/***** Public interface for persistent IO ********************/
    virtual int store_on(CNPstream& s) {return CNPIO::store_object(s, *this);}
    int store_on(CNPstream& s, bool no_ptr_check)
              {return CNPIO::store_object(s, *this, no_ptr_check);} 
    virtual int storer(CNPstream&);
    static CNObject* object_read_from(CNPstream& s)
              {return CNPIO::read_object(s);}
    static CNPInt* read_from(CNPstream& s)
              {return CNPInt::cast_from_object(CNPIO::read_object(s));}
    static CNPInt* reader(CNPstream& s) {return new CNPInt(s);}

    CNPID object_id() { return CNPObjectID::object_id(); }

  private:	/***** Internal private members ******************************/

  public:	/***** Member functions required by CNCL *********************/
    virtual CNClassDesc class_desc() const	// CNClass description
    { return CN_PINT; }
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    { return desc == CN_PINT ? TRUE : CNInt::is_a(desc); }
        
    static CNPInt *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNPInt *)obj;
#   else
	return (CNPInt *)( !obj || obj->is_a(CN_PINT)
	       ? obj : fatal_type(obj->class_desc(), CN_PINT) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNPInt(param) : new CNPInt; }
    
};

#endif /**__CNPInt_h**/
