//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: Binomial.c,v 0.30 1996-08-07 18:00:46+02 steppler Exp $
 *
 * CNClass: CNBinomial --- CNBinomial distributed random numbers
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************
 * original Copyright:
 * -------------------
 * Copyright (C) 1988 Free Software Foundation
 *    written by Dirk Grunwald (grunwald@cs.uiuc.edu)
 * 
 * This file is part of the GNU C++ Library.  This library is free
 * software; you can redistribute it and/or modify it under the terms of
 * the GNU Library General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This library is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "Binomial.h"



CNBinomial::CNBinomial(int n, double u, CNRNG *gen)
    : CNRandom(gen)
{
    pN = n; pU = u;
}

CNBinomial::CNBinomial (CNParam *) : CNRandom((CNRNG*)NIL)
{
    pN = 0;
    pU = 0;
}

CNBinomial::CNBinomial() : CNRandom((CNRNG*)NIL)
{
    pN = 0;
    pU = 0;
}

int CNBinomial::n() { return pN; }
int CNBinomial::n(int xn) { int tmp = pN; pN = xn; return tmp; }

double CNBinomial::u() { return pU; }
double CNBinomial::u(double xu) { double tmp = pU; pU = xu; return tmp;}



double CNBinomial::operator()()
{
    int s = 0;
    for (int i = 0; i < pN; i++) {
	if (pGenerator -> as_double() < pU) {
	    s++;
	}
    }
    return(double(s));
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNBinomial::print(ostream &strm) const
{
    strm << "n=" << pN << " u=" << pU << endl;
}

// Debug output
void CNBinomial::dump(ostream &strm) const
{
    strm << "CNBinomial { "
	 << "n=" << pN << " u=" << pU
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNBinomial
static CNClass CNBinomial_desc("CNBinomial", "$Revision: 0.30 $",
			   CNBinomial::new_object);

// "Type" for type checking functions
CNClassDesc CN_BINOMIAL = &CNBinomial_desc;






