//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: FiboG.h,v 0.30 1996-08-07 18:01:10+02 steppler Exp $
 *
 * CNClass: CNFiboG --- Fibonacci random number generator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#ifndef __FiboG_h
#define __FiboG_h


#include <CNCL/Class.h>
#include <CNCL/Param.h>

#include <CNCL/RNG.h>		// Base class

extern CNClassDesc CN_FIBOG;	// CNClass CNFiboG description


/*
 * The class CNFiboG
 */

class CNFiboG : public CNRNG
{
public:
    virtual unsigned long as_long32();
    virtual void reset();
    virtual bool has_long32() {return TRUE;}

    void seed_internal(unsigned long *);

    // Private members
private:
    // struct defines a knot of the circular queue 
    // used by the lagged Fibonacci algorithm
    struct Vknot
    {
	unsigned long v;
	Vknot *vnext;
    };
    unsigned long initialSeed;  // start value of initialization routine
    unsigned long Xn;		// generated value
    unsigned long cn, Vn;	// temporary values
    Vknot *V33, *V97, *Vanker;	// some pointers to the queue

    /***** Constructors ******************************************************/
public:
    CNFiboG(CNParam *) {}			// CNParam constructor
    CNFiboG(unsigned long init = 54217137);
    virtual ~CNFiboG();

    /***** Member functions required by CNCL *********************************/
public:
    virtual CNClassDesc class_desc() const	// CNClass description
    {
	return CN_FIBOG;
    };
            
    virtual bool is_a(CNClassDesc desc) const	// Type checking
    {
	return desc == CN_FIBOG ? TRUE : CNRNG::is_a(desc);
    };
        
    static CNFiboG *cast_from_object(CNObject *obj) // Safe type cast
    {
#   ifdef NO_TYPE_CHECK
	return (CNFiboG *)obj;
#   else
	return (CNFiboG *)( !obj || obj->is_a(CN_FIBOG)
	       ? obj : fatal_type(obj->class_desc(), CN_FIBOG) );
#   endif
    }
    
    static CNObject *new_object(CNParam *param = NIL) // Object creation
    { return param ? new CNFiboG(param) : new CNFiboG; }
    
    // Print/debug output
    virtual void print(ostream &strm = cout) const;
    virtual void dump (ostream &strm = cout) const;
};


#endif /**__FiboG_h**/
