//   -*- C++ -*-
/*****************************************************************************
 *
 *   |_|_|_  |_|_    |_    |_|_|_  |_		     C O M M U N I C A T I O N
 * |_        |_  |_  |_  |_        |_		               N E T W O R K S
 * |_        |_  |_  |_  |_        |_		                     C L A S S
 *   |_|_|_  |_    |_|_    |_|_|_  |_|_|_|_	                 L I B R A R Y
 *
 * $Id: LCG.c,v 0.31 1996-08-07 18:01:29+02 steppler Exp $
 *
 * CNClass: CNLCG --- Linear congruence random number generator
 *
 *****************************************************************************
 * Copyright (C) 1992-1996   Communication Networks
 *                           Aachen University of Technology
 *                           D-52056 Aachen
 *                           Germany
 *                           Email: cncl-adm@comnets.rwth-aachen.de
 *****************************************************************************
 * This file is part of the CN class library. All files marked with
 * this header are free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.  This library is
 * distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.  You should have received a copy of the GNU
 * Library General Public License along with this library; if not, write
 * to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *****************************************************************************/

#include "LCG.h"



CNLCG::CNLCG(unsigned long s)
{
    // avoid zero as seed
    if (s == 0)
	s = 929 ;

    initialSeed = s;
    reset();
}



void CNLCG::reset()
{
    state = initialSeed;
}



unsigned long CNLCG::as_long32()
{   
    // minimal standard due to Park and Miller (1986)
    // implementation uses the algorithm of Schrage (1979)
    // to avoid a possible overflow when calculating a * Xn-1 

    long k ;
    k = state / 127773 ;
    state = 16807*(state - k * 127773) - 2836 * k;
    if (state < 0)
	 state += 2147483647 ;
    return state;
}



void CNLCG::seed(unsigned long s)
{
    initialSeed = s;
    reset();
}



/***** Default I/O member function for CNCL classes **************************/

// CNNormal output
void CNLCG::print(ostream &strm) const
{
    strm << "state = " << state << endl;
}

// Debug output
void CNLCG::dump(ostream &strm) const
{
    strm << "CNLCG { "
	 << "state = " << state
	 << " }" << endl;
}



/***** CNCL stuff for type information and exemplar objects ******************/

// Describing object for class CNLCG
static CNClass CNLCG_desc("CNLCG", "$Revision: 0.31 $",
			  CNLCG::new_object);

// "Type" for type checking functions
CNClassDesc CN_LCG = &CNLCG_desc;






